/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;

public class DescribeConfigurationSettingsRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSettingsRequest>, DescribeConfigurationSettingsRequest> {
    public Request<DescribeConfigurationSettingsRequest> marshall(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        if (describeConfigurationSettingsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeConfigurationSettingsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeConfigurationSettings");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSettingsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringConversion.fromString((String)describeConfigurationSettingsRequest.applicationName()));
        }
        if (describeConfigurationSettingsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)describeConfigurationSettingsRequest.templateName()));
        }
        if (describeConfigurationSettingsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)describeConfigurationSettingsRequest.environmentName()));
        }
        return request;
    }
}

