/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest;

public class ApplyEnvironmentManagedActionRequestMarshaller
implements Marshaller<Request<ApplyEnvironmentManagedActionRequest>, ApplyEnvironmentManagedActionRequest> {
    public Request<ApplyEnvironmentManagedActionRequest> marshall(ApplyEnvironmentManagedActionRequest applyEnvironmentManagedActionRequest) {
        if (applyEnvironmentManagedActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)applyEnvironmentManagedActionRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "ApplyEnvironmentManagedAction");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (applyEnvironmentManagedActionRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringConversion.fromString((String)applyEnvironmentManagedActionRequest.environmentName()));
        }
        if (applyEnvironmentManagedActionRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringConversion.fromString((String)applyEnvironmentManagedActionRequest.environmentId()));
        }
        if (applyEnvironmentManagedActionRequest.actionId() != null) {
            request.addParameter("ActionId", StringConversion.fromString((String)applyEnvironmentManagedActionRequest.actionId()));
        }
        return request;
    }
}

