/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessage;
import software.amazon.awssdk.services.elasticbeanstalk.model.ValidationMessagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateConfigurationSettingsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
    private final List<ValidationMessage> messages;

    private ValidateConfigurationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
    }

    public List<ValidationMessage> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateConfigurationSettingsResponse)) {
            return false;
        }
        ValidateConfigurationSettingsResponse other = (ValidateConfigurationSettingsResponse)((Object)obj);
        return Objects.equals(this.messages(), other.messages());
    }

    public String toString() {
        return ToString.builder((String)"ValidateConfigurationSettingsResponse").add("Messages", this.messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private List<ValidationMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateConfigurationSettingsResponse model) {
            super(model);
            this.messages(model.messages);
        }

        public final Collection<ValidationMessage.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(ValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<ValidationMessage> messages) {
            this.messages = ValidationMessagesListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(ValidationMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<ValidationMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (ValidationMessage)((ValidationMessage.Builder)ValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<ValidationMessage.BuilderImpl> messages) {
            this.messages = ValidationMessagesListCopier.copyFromBuilder(messages);
        }

        @Override
        public ValidateConfigurationSettingsResponse build() {
            return new ValidateConfigurationSettingsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, ValidateConfigurationSettingsResponse> {
        public Builder messages(Collection<ValidationMessage> var1);

        public Builder messages(ValidationMessage ... var1);

        public Builder messages(Consumer<ValidationMessage.Builder> ... var1);
    }
}

