/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationsRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DescribeApplicationsRequest> {
    private final List<String> applicationNames;

    private DescribeApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationNames = builder.applicationNames;
    }

    public List<String> applicationNames() {
        return this.applicationNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest)((Object)obj);
        return Objects.equals(this.applicationNames(), other.applicationNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationsRequest").add("ApplicationNames", this.applicationNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationNames": {
                return Optional.ofNullable(clazz.cast(this.applicationNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private List<String> applicationNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsRequest model) {
            super(model);
            this.applicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String ... applicationNames) {
            this.applicationNames(Arrays.asList(applicationNames));
            return this;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationNamesListCopier.copy(applicationNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationsRequest build() {
            return new DescribeApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DescribeApplicationsRequest> {
        public Builder applicationNames(Collection<String> var1);

        public Builder applicationNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

