/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationRequest
extends ElasticBeanstalkRequest
implements ToCopyableBuilder<Builder, DeleteApplicationRequest> {
    private final String applicationName;
    private final Boolean terminateEnvByForce;

    private DeleteApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.terminateEnvByForce = builder.terminateEnvByForce;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Boolean terminateEnvByForce() {
        return this.terminateEnvByForce;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateEnvByForce());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationRequest)) {
            return false;
        }
        DeleteApplicationRequest other = (DeleteApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.terminateEnvByForce(), other.terminateEnvByForce());
    }

    public String toString() {
        return ToString.builder((String)"DeleteApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("TerminateEnvByForce", (Object)this.terminateEnvByForce()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "TerminateEnvByForce": {
                return Optional.ofNullable(clazz.cast(this.terminateEnvByForce()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Boolean terminateEnvByForce;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.terminateEnvByForce(model.terminateEnvByForce);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Boolean getTerminateEnvByForce() {
            return this.terminateEnvByForce;
        }

        @Override
        public final Builder terminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
            return this;
        }

        public final void setTerminateEnvByForce(Boolean terminateEnvByForce) {
            this.terminateEnvByForce = terminateEnvByForce;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationRequest build() {
            return new DeleteApplicationRequest(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkRequest.Builder,
    CopyableBuilder<Builder, DeleteApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder terminateEnvByForce(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

