/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticbeanstalk.model.ActionType;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplyEnvironmentManagedActionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
    private final String actionId;
    private final String actionDescription;
    private final String actionType;
    private final String status;

    private ApplyEnvironmentManagedActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionId = builder.actionId;
        this.actionDescription = builder.actionDescription;
        this.actionType = builder.actionType;
        this.status = builder.status;
    }

    public String actionId() {
        return this.actionId;
    }

    public String actionDescription() {
        return this.actionDescription;
    }

    public ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public String actionTypeAsString() {
        return this.actionType;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyEnvironmentManagedActionResponse)) {
            return false;
        }
        ApplyEnvironmentManagedActionResponse other = (ApplyEnvironmentManagedActionResponse)((Object)obj);
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.actionDescription(), other.actionDescription()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ApplyEnvironmentManagedActionResponse").add("ActionId", (Object)this.actionId()).add("ActionDescription", (Object)this.actionDescription()).add("ActionType", (Object)this.actionTypeAsString()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "ActionDescription": {
                return Optional.ofNullable(clazz.cast(this.actionDescription()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String actionId;
        private String actionDescription;
        private String actionType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyEnvironmentManagedActionResponse model) {
            super(model);
            this.actionId(model.actionId);
            this.actionDescription(model.actionDescription);
            this.actionType(model.actionType);
            this.status(model.status);
        }

        public final String getActionId() {
            return this.actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public final String getActionDescription() {
            return this.actionDescription;
        }

        @Override
        public final Builder actionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
            return this;
        }

        public final void setActionDescription(String actionDescription) {
            this.actionDescription = actionDescription;
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType.toString());
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public ApplyEnvironmentManagedActionResponse build() {
            return new ApplyEnvironmentManagedActionResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, ApplyEnvironmentManagedActionResponse> {
        public Builder actionId(String var1);

        public Builder actionDescription(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder status(String var1);
    }
}

