/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticbeanstalk.model.CPUUtilization;
import software.amazon.awssdk.services.elasticbeanstalk.model.LoadAverageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SystemStatus
implements ToCopyableBuilder<Builder, SystemStatus> {
    private final CPUUtilization cpuUtilization;
    private final List<Double> loadAverage;

    private SystemStatus(BuilderImpl builder) {
        this.cpuUtilization = builder.cpuUtilization;
        this.loadAverage = builder.loadAverage;
    }

    public CPUUtilization cpuUtilization() {
        return this.cpuUtilization;
    }

    public List<Double> loadAverage() {
        return this.loadAverage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadAverage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemStatus)) {
            return false;
        }
        SystemStatus other = (SystemStatus)obj;
        return Objects.equals(this.cpuUtilization(), other.cpuUtilization()) && Objects.equals(this.loadAverage(), other.loadAverage());
    }

    public String toString() {
        return ToString.builder((String)"SystemStatus").add("CPUUtilization", (Object)this.cpuUtilization()).add("LoadAverage", this.loadAverage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CPUUtilization": {
                return Optional.of(clazz.cast(this.cpuUtilization()));
            }
            case "LoadAverage": {
                return Optional.of(clazz.cast(this.loadAverage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private CPUUtilization cpuUtilization;
        private List<Double> loadAverage;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemStatus model) {
            this.cpuUtilization(model.cpuUtilization);
            this.loadAverage(model.loadAverage);
        }

        public final CPUUtilization.Builder getCPUUtilization() {
            return this.cpuUtilization != null ? this.cpuUtilization.toBuilder() : null;
        }

        @Override
        public final Builder cpuUtilization(CPUUtilization cpuUtilization) {
            this.cpuUtilization = cpuUtilization;
            return this;
        }

        public final void setCPUUtilization(CPUUtilization.BuilderImpl cpuUtilization) {
            this.cpuUtilization = cpuUtilization != null ? cpuUtilization.build() : null;
        }

        public final Collection<Double> getLoadAverage() {
            return this.loadAverage;
        }

        @Override
        public final Builder loadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadAverage(Double ... loadAverage) {
            this.loadAverage(Arrays.asList(loadAverage));
            return this;
        }

        public final void setLoadAverage(Collection<Double> loadAverage) {
            this.loadAverage = LoadAverageCopier.copy(loadAverage);
        }

        public SystemStatus build() {
            return new SystemStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SystemStatus> {
        public Builder cpuUtilization(CPUUtilization var1);

        default public Builder cpuUtilization(Consumer<CPUUtilization.Builder> cpuUtilization) {
            return this.cpuUtilization((CPUUtilization)((CPUUtilization.Builder)CPUUtilization.builder().apply(cpuUtilization)).build());
        }

        public Builder loadAverage(Collection<Double> var1);

        public Builder loadAverage(Double ... var1);
    }
}

