/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreatePlatformVersionResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, CreatePlatformVersionResponse> {
    private final PlatformSummary platformSummary;
    private final PlatformBuilder platformBuilder;

    private CreatePlatformVersionResponse(BuilderImpl builder) {
        super(builder);
        this.platformSummary = builder.platformSummary;
        this.platformBuilder = builder.platformBuilder;
    }

    public PlatformSummary platformSummary() {
        return this.platformSummary;
    }

    public PlatformBuilder platformBuilder() {
        return this.platformBuilder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platformSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformBuilder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlatformVersionResponse)) {
            return false;
        }
        CreatePlatformVersionResponse other = (CreatePlatformVersionResponse)((Object)obj);
        return Objects.equals(this.platformSummary(), other.platformSummary()) && Objects.equals(this.platformBuilder(), other.platformBuilder());
    }

    public String toString() {
        return ToString.builder((String)"CreatePlatformVersionResponse").add("PlatformSummary", (Object)this.platformSummary()).add("PlatformBuilder", (Object)this.platformBuilder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformSummary": {
                return Optional.of(clazz.cast(this.platformSummary()));
            }
            case "PlatformBuilder": {
                return Optional.of(clazz.cast(this.platformBuilder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private PlatformSummary platformSummary;
        private PlatformBuilder platformBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlatformVersionResponse model) {
            super(model);
            this.platformSummary(model.platformSummary);
            this.platformBuilder(model.platformBuilder);
        }

        public final PlatformSummary.Builder getPlatformSummary() {
            return this.platformSummary != null ? this.platformSummary.toBuilder() : null;
        }

        @Override
        public final Builder platformSummary(PlatformSummary platformSummary) {
            this.platformSummary = platformSummary;
            return this;
        }

        public final void setPlatformSummary(PlatformSummary.BuilderImpl platformSummary) {
            this.platformSummary = platformSummary != null ? platformSummary.build() : null;
        }

        public final PlatformBuilder.Builder getPlatformBuilder() {
            return this.platformBuilder != null ? this.platformBuilder.toBuilder() : null;
        }

        @Override
        public final Builder platformBuilder(PlatformBuilder platformBuilder) {
            this.platformBuilder = platformBuilder;
            return this;
        }

        public final void setPlatformBuilder(PlatformBuilder.BuilderImpl platformBuilder) {
            this.platformBuilder = platformBuilder != null ? platformBuilder.build() : null;
        }

        @Override
        public CreatePlatformVersionResponse build() {
            return new CreatePlatformVersionResponse(this);
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    CopyableBuilder<Builder, CreatePlatformVersionResponse> {
        public Builder platformSummary(PlatformSummary var1);

        default public Builder platformSummary(Consumer<PlatformSummary.Builder> platformSummary) {
            return this.platformSummary((PlatformSummary)((PlatformSummary.Builder)PlatformSummary.builder().apply(platformSummary)).build());
        }

        public Builder platformBuilder(PlatformBuilder var1);

        default public Builder platformBuilder(Consumer<PlatformBuilder.Builder> platformBuilder) {
            return this.platformBuilder((PlatformBuilder)((PlatformBuilder.Builder)PlatformBuilder.builder().apply(platformBuilder)).build());
        }
    }
}

