/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentTier;
import software.amazon.awssdk.services.elasticbeanstalk.model.OptionSpecification;
import software.amazon.awssdk.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateEnvironmentRequestMarshaller
implements Marshaller<Request<UpdateEnvironmentRequest>, UpdateEnvironmentRequest> {
    public Request<UpdateEnvironmentRequest> marshall(UpdateEnvironmentRequest updateEnvironmentRequest) {
        SdkInternalList optionsToRemoveList;
        SdkInternalList optionSettingsList;
        EnvironmentTier tier;
        if (updateEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "UpdateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateEnvironmentRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)updateEnvironmentRequest.applicationName()));
        }
        if (updateEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)updateEnvironmentRequest.environmentId()));
        }
        if (updateEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)updateEnvironmentRequest.environmentName()));
        }
        if (updateEnvironmentRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)updateEnvironmentRequest.groupName()));
        }
        if (updateEnvironmentRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateEnvironmentRequest.description()));
        }
        if ((tier = updateEnvironmentRequest.tier()) != null) {
            if (tier.name() != null) {
                request.addParameter("Tier.Name", StringUtils.fromString((String)tier.name()));
            }
            if (tier.type() != null) {
                request.addParameter("Tier.Type", StringUtils.fromString((String)tier.type()));
            }
            if (tier.version() != null) {
                request.addParameter("Tier.Version", StringUtils.fromString((String)tier.version()));
            }
        }
        if (updateEnvironmentRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)updateEnvironmentRequest.versionLabel()));
        }
        if (updateEnvironmentRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)updateEnvironmentRequest.templateName()));
        }
        if (updateEnvironmentRequest.solutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString((String)updateEnvironmentRequest.solutionStackName()));
        }
        if (updateEnvironmentRequest.platformArn() != null) {
            request.addParameter("PlatformArn", StringUtils.fromString((String)updateEnvironmentRequest.platformArn()));
        }
        if (!(optionSettingsList = (SdkInternalList)updateEnvironmentRequest.optionSettings()).isEmpty() || !optionSettingsList.isAutoConstruct()) {
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.resourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.resourceName()));
                }
                if (optionSettingsListValue.namespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.namespace()));
                }
                if (optionSettingsListValue.optionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.optionName()));
                }
                if (optionSettingsListValue.value() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.value()));
                }
                ++optionSettingsListIndex;
            }
        }
        if (!(optionsToRemoveList = (SdkInternalList)updateEnvironmentRequest.optionsToRemove()).isEmpty() || !optionsToRemoveList.isAutoConstruct()) {
            int optionsToRemoveListIndex = 1;
            for (OptionSpecification optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue.resourceName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".ResourceName", StringUtils.fromString((String)optionsToRemoveListValue.resourceName()));
                }
                if (optionsToRemoveListValue.namespace() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".Namespace", StringUtils.fromString((String)optionsToRemoveListValue.namespace()));
                }
                if (optionsToRemoveListValue.optionName() != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex + ".OptionName", StringUtils.fromString((String)optionsToRemoveListValue.optionName()));
                }
                ++optionsToRemoveListIndex;
            }
        }
        return request;
    }
}

