/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import software.amazon.awssdk.util.StringUtils;

public class TerminateEnvironmentRequestMarshaller
implements Marshaller<Request<TerminateEnvironmentRequest>, TerminateEnvironmentRequest> {
    public Request<TerminateEnvironmentRequest> marshall(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        if (terminateEnvironmentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateEnvironmentRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "TerminateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (terminateEnvironmentRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)terminateEnvironmentRequest.environmentId()));
        }
        if (terminateEnvironmentRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)terminateEnvironmentRequest.environmentName()));
        }
        if (terminateEnvironmentRequest.terminateResources() != null) {
            request.addParameter("TerminateResources", StringUtils.fromBoolean((Boolean)terminateEnvironmentRequest.terminateResources()));
        }
        if (terminateEnvironmentRequest.forceTerminate() != null) {
            request.addParameter("ForceTerminate", StringUtils.fromBoolean((Boolean)terminateEnvironmentRequest.forceTerminate()));
        }
        return request;
    }
}

