/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SystemStatus;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CPUUtilizationUnmarshaller;

public class SystemStatusUnmarshaller
implements Unmarshaller<SystemStatus, StaxUnmarshallerContext> {
    private static SystemStatusUnmarshaller INSTANCE;

    public SystemStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SystemStatus.Builder systemStatus = SystemStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CPUUtilization", targetDepth)) {
                    systemStatus.cpuUtilization(CPUUtilizationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadAverage", targetDepth)) {
                    systemStatus.loadAverage(new ArrayList<Double>());
                    continue;
                }
                if (!context.testExpression("LoadAverage/member", targetDepth)) continue;
                systemStatus.loadAverage(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SystemStatus)systemStatus.build();
    }

    public static SystemStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SystemStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

