/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.SingleInstanceHealth;
import software.amazon.awssdk.services.elasticbeanstalk.transform.ApplicationMetricsUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.DeploymentUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.SystemStatusUnmarshaller;

public class SingleInstanceHealthUnmarshaller
implements Unmarshaller<SingleInstanceHealth, StaxUnmarshallerContext> {
    private static SingleInstanceHealthUnmarshaller INSTANCE;

    public SingleInstanceHealth unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SingleInstanceHealth.Builder singleInstanceHealth = SingleInstanceHealth.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("InstanceId", targetDepth)) {
                    singleInstanceHealth.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthStatus", targetDepth)) {
                    singleInstanceHealth.healthStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Color", targetDepth)) {
                    singleInstanceHealth.color(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Causes", targetDepth)) {
                    singleInstanceHealth.causes(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Causes/member", targetDepth)) {
                    singleInstanceHealth.causes(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchedAt", targetDepth)) {
                    singleInstanceHealth.launchedAt(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ApplicationMetrics", targetDepth)) {
                    singleInstanceHealth.applicationMetrics(ApplicationMetricsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("System", targetDepth)) {
                    singleInstanceHealth.system(SystemStatusUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Deployment", targetDepth)) {
                    singleInstanceHealth.deployment(DeploymentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    singleInstanceHealth.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InstanceType", targetDepth)) continue;
                singleInstanceHealth.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SingleInstanceHealth)singleInstanceHealth.build();
    }

    public static SingleInstanceHealthUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SingleInstanceHealthUnmarshaller();
        }
        return INSTANCE;
    }
}

