/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary;

public class PlatformSummaryUnmarshaller
implements Unmarshaller<PlatformSummary, StaxUnmarshallerContext> {
    private static PlatformSummaryUnmarshaller INSTANCE;

    public PlatformSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PlatformSummary.Builder platformSummary = PlatformSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PlatformArn", targetDepth)) {
                    platformSummary.platformArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformOwner", targetDepth)) {
                    platformSummary.platformOwner(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformStatus", targetDepth)) {
                    platformSummary.platformStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformCategory", targetDepth)) {
                    platformSummary.platformCategory(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemName", targetDepth)) {
                    platformSummary.operatingSystemName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemVersion", targetDepth)) {
                    platformSummary.operatingSystemVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTierList", targetDepth)) {
                    platformSummary.supportedTierList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedTierList/member", targetDepth)) {
                    platformSummary.supportedTierList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedAddonList", targetDepth)) {
                    platformSummary.supportedAddonList(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("SupportedAddonList/member", targetDepth)) continue;
                platformSummary.supportedAddonList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PlatformSummary)platformSummary.build();
    }

    public static PlatformSummaryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformSummaryUnmarshaller();
        }
        return INSTANCE;
    }
}

