/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFilter;

public class PlatformFilterUnmarshaller
implements Unmarshaller<PlatformFilter, StaxUnmarshallerContext> {
    private static PlatformFilterUnmarshaller INSTANCE;

    public PlatformFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PlatformFilter.Builder platformFilter = PlatformFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Type", targetDepth)) {
                    platformFilter.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Operator", targetDepth)) {
                    platformFilter.operator(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Values", targetDepth)) {
                    platformFilter.values(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Values/member", targetDepth)) continue;
                platformFilter.values(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PlatformFilter)platformFilter.build();
    }

    public static PlatformFilterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformFilterUnmarshaller();
        }
        return INSTANCE;
    }
}

