/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.CustomAmi;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformFramework;
import software.amazon.awssdk.services.elasticbeanstalk.model.PlatformProgrammingLanguage;
import software.amazon.awssdk.services.elasticbeanstalk.transform.CustomAmiUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.PlatformFrameworkUnmarshaller;
import software.amazon.awssdk.services.elasticbeanstalk.transform.PlatformProgrammingLanguageUnmarshaller;

public class PlatformDescriptionUnmarshaller
implements Unmarshaller<PlatformDescription, StaxUnmarshallerContext> {
    private static PlatformDescriptionUnmarshaller INSTANCE;

    public PlatformDescription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PlatformDescription.Builder platformDescription = PlatformDescription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("PlatformArn", targetDepth)) {
                    platformDescription.platformArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformOwner", targetDepth)) {
                    platformDescription.platformOwner(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformName", targetDepth)) {
                    platformDescription.platformName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformVersion", targetDepth)) {
                    platformDescription.platformVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SolutionStackName", targetDepth)) {
                    platformDescription.solutionStackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformStatus", targetDepth)) {
                    platformDescription.platformStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateCreated", targetDepth)) {
                    platformDescription.dateCreated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateUpdated", targetDepth)) {
                    platformDescription.dateUpdated(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlatformCategory", targetDepth)) {
                    platformDescription.platformCategory(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Description", targetDepth)) {
                    platformDescription.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Maintainer", targetDepth)) {
                    platformDescription.maintainer(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemName", targetDepth)) {
                    platformDescription.operatingSystemName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperatingSystemVersion", targetDepth)) {
                    platformDescription.operatingSystemVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ProgrammingLanguages", targetDepth)) {
                    platformDescription.programmingLanguages(new ArrayList<PlatformProgrammingLanguage>());
                    continue;
                }
                if (context.testExpression("ProgrammingLanguages/member", targetDepth)) {
                    platformDescription.programmingLanguages(PlatformProgrammingLanguageUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Frameworks", targetDepth)) {
                    platformDescription.frameworks(new ArrayList<PlatformFramework>());
                    continue;
                }
                if (context.testExpression("Frameworks/member", targetDepth)) {
                    platformDescription.frameworks(PlatformFrameworkUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomAmiList", targetDepth)) {
                    platformDescription.customAmiList(new ArrayList<CustomAmi>());
                    continue;
                }
                if (context.testExpression("CustomAmiList/member", targetDepth)) {
                    platformDescription.customAmiList(CustomAmiUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedTierList", targetDepth)) {
                    platformDescription.supportedTierList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SupportedTierList/member", targetDepth)) {
                    platformDescription.supportedTierList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SupportedAddonList", targetDepth)) {
                    platformDescription.supportedAddonList(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("SupportedAddonList/member", targetDepth)) continue;
                platformDescription.supportedAddonList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PlatformDescription)platformDescription.build();
    }

    public static PlatformDescriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformDescriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

