/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeInstancesHealthRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeInstancesHealthRequestMarshaller
implements Marshaller<Request<DescribeInstancesHealthRequest>, DescribeInstancesHealthRequest> {
    public Request<DescribeInstancesHealthRequest> marshall(DescribeInstancesHealthRequest describeInstancesHealthRequest) {
        SdkInternalList attributeNamesList;
        if (describeInstancesHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstancesHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeInstancesHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstancesHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeInstancesHealthRequest.environmentName()));
        }
        if (describeInstancesHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeInstancesHealthRequest.environmentId()));
        }
        if (!(attributeNamesList = (SdkInternalList)describeInstancesHealthRequest.attributeNames()).isEmpty() || !attributeNamesList.isAutoConstruct()) {
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (describeInstancesHealthRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstancesHealthRequest.nextToken()));
        }
        return request;
    }
}

