/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        SdkInternalList environmentNamesList;
        SdkInternalList environmentIdsList;
        if (describeEnvironmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEnvironmentsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeEnvironmentsRequest.applicationName()));
        }
        if (describeEnvironmentsRequest.versionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString((String)describeEnvironmentsRequest.versionLabel()));
        }
        if (!(environmentIdsList = (SdkInternalList)describeEnvironmentsRequest.environmentIds()).isEmpty() || !environmentIdsList.isAutoConstruct()) {
            int environmentIdsListIndex = 1;
            for (String environmentIdsListValue : environmentIdsList) {
                if (environmentIdsListValue != null) {
                    request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringUtils.fromString((String)environmentIdsListValue));
                }
                ++environmentIdsListIndex;
            }
        }
        if (!(environmentNamesList = (SdkInternalList)describeEnvironmentsRequest.environmentNames()).isEmpty() || !environmentNamesList.isAutoConstruct()) {
            int environmentNamesListIndex = 1;
            for (String environmentNamesListValue : environmentNamesList) {
                if (environmentNamesListValue != null) {
                    request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringUtils.fromString((String)environmentNamesListValue));
                }
                ++environmentNamesListIndex;
            }
        }
        if (describeEnvironmentsRequest.includeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringUtils.fromBoolean((Boolean)describeEnvironmentsRequest.includeDeleted()));
        }
        if (describeEnvironmentsRequest.includedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringUtils.fromDate((Date)describeEnvironmentsRequest.includedDeletedBackTo()));
        }
        return request;
    }
}

