/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeEnvironmentHealthRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentHealthRequest>, DescribeEnvironmentHealthRequest> {
    public Request<DescribeEnvironmentHealthRequest> marshall(DescribeEnvironmentHealthRequest describeEnvironmentHealthRequest) {
        SdkInternalList attributeNamesList;
        if (describeEnvironmentHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEnvironmentHealthRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeEnvironmentHealth");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEnvironmentHealthRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeEnvironmentHealthRequest.environmentName()));
        }
        if (describeEnvironmentHealthRequest.environmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)describeEnvironmentHealthRequest.environmentId()));
        }
        if (!(attributeNamesList = (SdkInternalList)describeEnvironmentHealthRequest.attributeNames()).isEmpty() || !attributeNamesList.isAutoConstruct()) {
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeNames.member." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

