/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeConfigurationSettingsRequestMarshaller
implements Marshaller<Request<DescribeConfigurationSettingsRequest>, DescribeConfigurationSettingsRequest> {
    public Request<DescribeConfigurationSettingsRequest> marshall(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        if (describeConfigurationSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConfigurationSettingsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeConfigurationSettings");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeConfigurationSettingsRequest.applicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)describeConfigurationSettingsRequest.applicationName()));
        }
        if (describeConfigurationSettingsRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)describeConfigurationSettingsRequest.templateName()));
        }
        if (describeConfigurationSettingsRequest.environmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)describeConfigurationSettingsRequest.environmentName()));
        }
        return request;
    }
}

