/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeApplicationsRequestMarshaller
implements Marshaller<Request<DescribeApplicationsRequest>, DescribeApplicationsRequest> {
    public Request<DescribeApplicationsRequest> marshall(DescribeApplicationsRequest describeApplicationsRequest) {
        if (describeApplicationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationsRequest, "ElasticBeanstalkClient");
        request.addParameter("Action", "DescribeApplications");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList applicationNamesList = (SdkInternalList)describeApplicationsRequest.applicationNames();
        if (!applicationNamesList.isEmpty() || !applicationNamesList.isAutoConstruct()) {
            int applicationNamesListIndex = 1;
            for (String applicationNamesListValue : applicationNamesList) {
                if (applicationNamesListValue != null) {
                    request.addParameter("ApplicationNames.member." + applicationNamesListIndex, StringUtils.fromString((String)applicationNamesListValue));
                }
                ++applicationNamesListIndex;
            }
        }
        return request;
    }
}

