/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.elasticbeanstalk.model.SolutionStackFileTypeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SolutionStackDescription
implements ToCopyableBuilder<Builder, SolutionStackDescription> {
    private final String solutionStackName;
    private final List<String> permittedFileTypes;

    private SolutionStackDescription(BuilderImpl builder) {
        this.solutionStackName = builder.solutionStackName;
        this.permittedFileTypes = builder.permittedFileTypes;
    }

    public String solutionStackName() {
        return this.solutionStackName;
    }

    public List<String> permittedFileTypes() {
        return this.permittedFileTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.solutionStackName() == null ? 0 : this.solutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.permittedFileTypes() == null ? 0 : this.permittedFileTypes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SolutionStackDescription)) {
            return false;
        }
        SolutionStackDescription other = (SolutionStackDescription)obj;
        if (other.solutionStackName() == null ^ this.solutionStackName() == null) {
            return false;
        }
        if (other.solutionStackName() != null && !other.solutionStackName().equals(this.solutionStackName())) {
            return false;
        }
        if (other.permittedFileTypes() == null ^ this.permittedFileTypes() == null) {
            return false;
        }
        return other.permittedFileTypes() == null || other.permittedFileTypes().equals(this.permittedFileTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.solutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.solutionStackName()).append(",");
        }
        if (this.permittedFileTypes() != null) {
            sb.append("PermittedFileTypes: ").append(this.permittedFileTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String solutionStackName;
        private List<String> permittedFileTypes = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(SolutionStackDescription model) {
            this.setSolutionStackName(model.solutionStackName);
            this.setPermittedFileTypes(model.permittedFileTypes);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        public final Collection<String> getPermittedFileTypes() {
            return this.permittedFileTypes;
        }

        @Override
        public final Builder permittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedFileTypes(String ... permittedFileTypes) {
            if (this.permittedFileTypes == null) {
                this.permittedFileTypes = new SdkInternalList(permittedFileTypes.length);
            }
            for (String e : permittedFileTypes) {
                this.permittedFileTypes.add(e);
            }
            return this;
        }

        public final void setPermittedFileTypes(Collection<String> permittedFileTypes) {
            this.permittedFileTypes = SolutionStackFileTypeListCopier.copy(permittedFileTypes);
        }

        @SafeVarargs
        public final void setPermittedFileTypes(String ... permittedFileTypes) {
            if (this.permittedFileTypes == null) {
                this.permittedFileTypes = new SdkInternalList(permittedFileTypes.length);
            }
            for (String e : permittedFileTypes) {
                this.permittedFileTypes.add(e);
            }
        }

        public SolutionStackDescription build() {
            return new SolutionStackDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SolutionStackDescription> {
        public Builder solutionStackName(String var1);

        public Builder permittedFileTypes(Collection<String> var1);

        public Builder permittedFileTypes(String ... var1);
    }
}

