/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteApplicationVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteApplicationVersionRequest> {
    private final String applicationName;
    private final String versionLabel;
    private final Boolean deleteSourceBundle;

    private DeleteApplicationVersionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.deleteSourceBundle = builder.deleteSourceBundle;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String versionLabel() {
        return this.versionLabel;
    }

    public Boolean deleteSourceBundle() {
        return this.deleteSourceBundle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.versionLabel() == null ? 0 : this.versionLabel().hashCode());
        hashCode = 31 * hashCode + (this.deleteSourceBundle() == null ? 0 : this.deleteSourceBundle().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationVersionRequest)) {
            return false;
        }
        DeleteApplicationVersionRequest other = (DeleteApplicationVersionRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.versionLabel() == null ^ this.versionLabel() == null) {
            return false;
        }
        if (other.versionLabel() != null && !other.versionLabel().equals(this.versionLabel())) {
            return false;
        }
        if (other.deleteSourceBundle() == null ^ this.deleteSourceBundle() == null) {
            return false;
        }
        return other.deleteSourceBundle() == null || other.deleteSourceBundle().equals(this.deleteSourceBundle());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.versionLabel() != null) {
            sb.append("VersionLabel: ").append(this.versionLabel()).append(",");
        }
        if (this.deleteSourceBundle() != null) {
            sb.append("DeleteSourceBundle: ").append(this.deleteSourceBundle()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String versionLabel;
        private Boolean deleteSourceBundle;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationVersionRequest model) {
            this.setApplicationName(model.applicationName);
            this.setVersionLabel(model.versionLabel);
            this.setDeleteSourceBundle(model.deleteSourceBundle);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        public final Boolean getDeleteSourceBundle() {
            return this.deleteSourceBundle;
        }

        @Override
        public final Builder deleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
            return this;
        }

        public final void setDeleteSourceBundle(Boolean deleteSourceBundle) {
            this.deleteSourceBundle = deleteSourceBundle;
        }

        public DeleteApplicationVersionRequest build() {
            return new DeleteApplicationVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteApplicationVersionRequest> {
        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder deleteSourceBundle(Boolean var1);
    }
}

