/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationResourceLifecycleConfig
implements ToCopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
    private final String serviceRole;
    private final ApplicationVersionLifecycleConfig versionLifecycleConfig;

    private ApplicationResourceLifecycleConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.versionLifecycleConfig = builder.versionLifecycleConfig;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public ApplicationVersionLifecycleConfig versionLifecycleConfig() {
        return this.versionLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.versionLifecycleConfig() == null ? 0 : this.versionLifecycleConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationResourceLifecycleConfig)) {
            return false;
        }
        ApplicationResourceLifecycleConfig other = (ApplicationResourceLifecycleConfig)obj;
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.versionLifecycleConfig() == null ^ this.versionLifecycleConfig() == null) {
            return false;
        }
        return other.versionLifecycleConfig() == null || other.versionLifecycleConfig().equals(this.versionLifecycleConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.versionLifecycleConfig() != null) {
            sb.append("VersionLifecycleConfig: ").append(this.versionLifecycleConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String serviceRole;
        private ApplicationVersionLifecycleConfig versionLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationResourceLifecycleConfig model) {
            this.setServiceRole(model.serviceRole);
            this.setVersionLifecycleConfig(model.versionLifecycleConfig);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final ApplicationVersionLifecycleConfig getVersionLifecycleConfig() {
            return this.versionLifecycleConfig;
        }

        @Override
        public final Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig;
            return this;
        }

        public final void setVersionLifecycleConfig(ApplicationVersionLifecycleConfig versionLifecycleConfig) {
            this.versionLifecycleConfig = versionLifecycleConfig;
        }

        public ApplicationResourceLifecycleConfig build() {
            return new ApplicationResourceLifecycleConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationResourceLifecycleConfig> {
        public Builder serviceRole(String var1);

        public Builder versionLifecycleConfig(ApplicationVersionLifecycleConfig var1);
    }
}

