/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationTemplateNamesListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.VersionLabelsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationDescription
implements ToCopyableBuilder<Builder, ApplicationDescription> {
    private final String applicationName;
    private final String description;
    private final Date dateCreated;
    private final Date dateUpdated;
    private final List<String> versions;
    private final List<String> configurationTemplates;
    private final ApplicationResourceLifecycleConfig resourceLifecycleConfig;

    private ApplicationDescription(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.description = builder.description;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.versions = builder.versions;
        this.configurationTemplates = builder.configurationTemplates;
        this.resourceLifecycleConfig = builder.resourceLifecycleConfig;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String description() {
        return this.description;
    }

    public Date dateCreated() {
        return this.dateCreated;
    }

    public Date dateUpdated() {
        return this.dateUpdated;
    }

    public List<String> versions() {
        return this.versions;
    }

    public List<String> configurationTemplates() {
        return this.configurationTemplates;
    }

    public ApplicationResourceLifecycleConfig resourceLifecycleConfig() {
        return this.resourceLifecycleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.dateCreated() == null ? 0 : this.dateCreated().hashCode());
        hashCode = 31 * hashCode + (this.dateUpdated() == null ? 0 : this.dateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        hashCode = 31 * hashCode + (this.configurationTemplates() == null ? 0 : this.configurationTemplates().hashCode());
        hashCode = 31 * hashCode + (this.resourceLifecycleConfig() == null ? 0 : this.resourceLifecycleConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription)obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.dateCreated() == null ^ this.dateCreated() == null) {
            return false;
        }
        if (other.dateCreated() != null && !other.dateCreated().equals(this.dateCreated())) {
            return false;
        }
        if (other.dateUpdated() == null ^ this.dateUpdated() == null) {
            return false;
        }
        if (other.dateUpdated() != null && !other.dateUpdated().equals(this.dateUpdated())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        if (other.versions() != null && !other.versions().equals(this.versions())) {
            return false;
        }
        if (other.configurationTemplates() == null ^ this.configurationTemplates() == null) {
            return false;
        }
        if (other.configurationTemplates() != null && !other.configurationTemplates().equals(this.configurationTemplates())) {
            return false;
        }
        if (other.resourceLifecycleConfig() == null ^ this.resourceLifecycleConfig() == null) {
            return false;
        }
        return other.resourceLifecycleConfig() == null || other.resourceLifecycleConfig().equals(this.resourceLifecycleConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.dateCreated() != null) {
            sb.append("DateCreated: ").append(this.dateCreated()).append(",");
        }
        if (this.dateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.dateUpdated()).append(",");
        }
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        if (this.configurationTemplates() != null) {
            sb.append("ConfigurationTemplates: ").append(this.configurationTemplates()).append(",");
        }
        if (this.resourceLifecycleConfig() != null) {
            sb.append("ResourceLifecycleConfig: ").append(this.resourceLifecycleConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String description;
        private Date dateCreated;
        private Date dateUpdated;
        private List<String> versions = new SdkInternalList();
        private List<String> configurationTemplates = new SdkInternalList();
        private ApplicationResourceLifecycleConfig resourceLifecycleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDescription model) {
            this.setApplicationName(model.applicationName);
            this.setDescription(model.description);
            this.setDateCreated(model.dateCreated);
            this.setDateUpdated(model.dateUpdated);
            this.setVersions(model.versions);
            this.setConfigurationTemplates(model.configurationTemplates);
            this.setResourceLifecycleConfig(model.resourceLifecycleConfig);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public final Builder dateCreated(Date dateCreated) {
            this.dateCreated = StandardMemberCopier.copy((Date)dateCreated);
            return this;
        }

        public final void setDateCreated(Date dateCreated) {
            this.dateCreated = StandardMemberCopier.copy((Date)dateCreated);
        }

        public final Date getDateUpdated() {
            return this.dateUpdated;
        }

        @Override
        public final Builder dateUpdated(Date dateUpdated) {
            this.dateUpdated = StandardMemberCopier.copy((Date)dateUpdated);
            return this;
        }

        public final void setDateUpdated(Date dateUpdated) {
            this.dateUpdated = StandardMemberCopier.copy((Date)dateUpdated);
        }

        public final Collection<String> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            if (this.versions == null) {
                this.versions = new SdkInternalList(versions.length);
            }
            for (String e : versions) {
                this.versions.add(e);
            }
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionLabelsListCopier.copy(versions);
        }

        @SafeVarargs
        public final void setVersions(String ... versions) {
            if (this.versions == null) {
                this.versions = new SdkInternalList(versions.length);
            }
            for (String e : versions) {
                this.versions.add(e);
            }
        }

        public final Collection<String> getConfigurationTemplates() {
            return this.configurationTemplates;
        }

        @Override
        public final Builder configurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(String ... configurationTemplates) {
            if (this.configurationTemplates == null) {
                this.configurationTemplates = new SdkInternalList(configurationTemplates.length);
            }
            for (String e : configurationTemplates) {
                this.configurationTemplates.add(e);
            }
            return this;
        }

        public final void setConfigurationTemplates(Collection<String> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplateNamesListCopier.copy(configurationTemplates);
        }

        @SafeVarargs
        public final void setConfigurationTemplates(String ... configurationTemplates) {
            if (this.configurationTemplates == null) {
                this.configurationTemplates = new SdkInternalList(configurationTemplates.length);
            }
            for (String e : configurationTemplates) {
                this.configurationTemplates.add(e);
            }
        }

        public final ApplicationResourceLifecycleConfig getResourceLifecycleConfig() {
            return this.resourceLifecycleConfig;
        }

        @Override
        public final Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
            return this;
        }

        public final void setResourceLifecycleConfig(ApplicationResourceLifecycleConfig resourceLifecycleConfig) {
            this.resourceLifecycleConfig = resourceLifecycleConfig;
        }

        public ApplicationDescription build() {
            return new ApplicationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationDescription> {
        public Builder applicationName(String var1);

        public Builder description(String var1);

        public Builder dateCreated(Date var1);

        public Builder dateUpdated(Date var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder configurationTemplates(Collection<String> var1);

        public Builder configurationTemplates(String ... var1);

        public Builder resourceLifecycleConfig(ApplicationResourceLifecycleConfig var1);
    }
}

