/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.NodeUpdateInitiatedBy;
import software.amazon.awssdk.services.elasticache.model.NodeUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeGroupMemberUpdateStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeGroupMemberUpdateStatus> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::cacheClusterId)).setter(NodeGroupMemberUpdateStatus.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::cacheNodeId)).setter(NodeGroupMemberUpdateStatus.setter(Builder::cacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build();
    private static final SdkField<String> NODE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateStatusAsString)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatus").build()}).build();
    private static final SdkField<Instant> NODE_DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeDeletionDate)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeDeletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDeletionDate").build()}).build();
    private static final SdkField<Instant> NODE_UPDATE_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateStartDate)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStartDate").build()}).build();
    private static final SdkField<Instant> NODE_UPDATE_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateEndDate)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateEndDate").build()}).build();
    private static final SdkField<String> NODE_UPDATE_INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateInitiatedByAsString)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateInitiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedBy").build()}).build();
    private static final SdkField<Instant> NODE_UPDATE_INITIATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateInitiatedDate)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateInitiatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedDate").build()}).build();
    private static final SdkField<Instant> NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(NodeGroupMemberUpdateStatus.getter(NodeGroupMemberUpdateStatus::nodeUpdateStatusModifiedDate)).setter(NodeGroupMemberUpdateStatus.setter(Builder::nodeUpdateStatusModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatusModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, CACHE_NODE_ID_FIELD, NODE_UPDATE_STATUS_FIELD, NODE_DELETION_DATE_FIELD, NODE_UPDATE_START_DATE_FIELD, NODE_UPDATE_END_DATE_FIELD, NODE_UPDATE_INITIATED_BY_FIELD, NODE_UPDATE_INITIATED_DATE_FIELD, NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cacheClusterId;
    private final String cacheNodeId;
    private final String nodeUpdateStatus;
    private final Instant nodeDeletionDate;
    private final Instant nodeUpdateStartDate;
    private final Instant nodeUpdateEndDate;
    private final String nodeUpdateInitiatedBy;
    private final Instant nodeUpdateInitiatedDate;
    private final Instant nodeUpdateStatusModifiedDate;

    private NodeGroupMemberUpdateStatus(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeUpdateStatus = builder.nodeUpdateStatus;
        this.nodeDeletionDate = builder.nodeDeletionDate;
        this.nodeUpdateStartDate = builder.nodeUpdateStartDate;
        this.nodeUpdateEndDate = builder.nodeUpdateEndDate;
        this.nodeUpdateInitiatedBy = builder.nodeUpdateInitiatedBy;
        this.nodeUpdateInitiatedDate = builder.nodeUpdateInitiatedDate;
        this.nodeUpdateStatusModifiedDate = builder.nodeUpdateStatusModifiedDate;
    }

    public String cacheClusterId() {
        return this.cacheClusterId;
    }

    public String cacheNodeId() {
        return this.cacheNodeId;
    }

    public NodeUpdateStatus nodeUpdateStatus() {
        return NodeUpdateStatus.fromValue(this.nodeUpdateStatus);
    }

    public String nodeUpdateStatusAsString() {
        return this.nodeUpdateStatus;
    }

    public Instant nodeDeletionDate() {
        return this.nodeDeletionDate;
    }

    public Instant nodeUpdateStartDate() {
        return this.nodeUpdateStartDate;
    }

    public Instant nodeUpdateEndDate() {
        return this.nodeUpdateEndDate;
    }

    public NodeUpdateInitiatedBy nodeUpdateInitiatedBy() {
        return NodeUpdateInitiatedBy.fromValue(this.nodeUpdateInitiatedBy);
    }

    public String nodeUpdateInitiatedByAsString() {
        return this.nodeUpdateInitiatedBy;
    }

    public Instant nodeUpdateInitiatedDate() {
        return this.nodeUpdateInitiatedDate;
    }

    public Instant nodeUpdateStatusModifiedDate() {
        return this.nodeUpdateStatusModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeDeletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateInitiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateInitiatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUpdateStatusModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMemberUpdateStatus)) {
            return false;
        }
        NodeGroupMemberUpdateStatus other = (NodeGroupMemberUpdateStatus)obj;
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.nodeUpdateStatusAsString(), other.nodeUpdateStatusAsString()) && Objects.equals(this.nodeDeletionDate(), other.nodeDeletionDate()) && Objects.equals(this.nodeUpdateStartDate(), other.nodeUpdateStartDate()) && Objects.equals(this.nodeUpdateEndDate(), other.nodeUpdateEndDate()) && Objects.equals(this.nodeUpdateInitiatedByAsString(), other.nodeUpdateInitiatedByAsString()) && Objects.equals(this.nodeUpdateInitiatedDate(), other.nodeUpdateInitiatedDate()) && Objects.equals(this.nodeUpdateStatusModifiedDate(), other.nodeUpdateStatusModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"NodeGroupMemberUpdateStatus").add("CacheClusterId", (Object)this.cacheClusterId()).add("CacheNodeId", (Object)this.cacheNodeId()).add("NodeUpdateStatus", (Object)this.nodeUpdateStatusAsString()).add("NodeDeletionDate", (Object)this.nodeDeletionDate()).add("NodeUpdateStartDate", (Object)this.nodeUpdateStartDate()).add("NodeUpdateEndDate", (Object)this.nodeUpdateEndDate()).add("NodeUpdateInitiatedBy", (Object)this.nodeUpdateInitiatedByAsString()).add("NodeUpdateInitiatedDate", (Object)this.nodeUpdateInitiatedDate()).add("NodeUpdateStatusModifiedDate", (Object)this.nodeUpdateStatusModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "CacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeId()));
            }
            case "NodeUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateStatusAsString()));
            }
            case "NodeDeletionDate": {
                return Optional.ofNullable(clazz.cast(this.nodeDeletionDate()));
            }
            case "NodeUpdateStartDate": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateStartDate()));
            }
            case "NodeUpdateEndDate": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateEndDate()));
            }
            case "NodeUpdateInitiatedBy": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateInitiatedByAsString()));
            }
            case "NodeUpdateInitiatedDate": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateInitiatedDate()));
            }
            case "NodeUpdateStatusModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.nodeUpdateStatusModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupMemberUpdateStatus, T> g) {
        return obj -> g.apply((NodeGroupMemberUpdateStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String cacheNodeId;
        private String nodeUpdateStatus;
        private Instant nodeDeletionDate;
        private Instant nodeUpdateStartDate;
        private Instant nodeUpdateEndDate;
        private String nodeUpdateInitiatedBy;
        private Instant nodeUpdateInitiatedDate;
        private Instant nodeUpdateStatusModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMemberUpdateStatus model) {
            this.cacheClusterId(model.cacheClusterId);
            this.cacheNodeId(model.cacheNodeId);
            this.nodeUpdateStatus(model.nodeUpdateStatus);
            this.nodeDeletionDate(model.nodeDeletionDate);
            this.nodeUpdateStartDate(model.nodeUpdateStartDate);
            this.nodeUpdateEndDate(model.nodeUpdateEndDate);
            this.nodeUpdateInitiatedBy(model.nodeUpdateInitiatedBy);
            this.nodeUpdateInitiatedDate(model.nodeUpdateInitiatedDate);
            this.nodeUpdateStatusModifiedDate(model.nodeUpdateStatusModifiedDate);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final String getNodeUpdateStatusAsString() {
            return this.nodeUpdateStatus;
        }

        @Override
        public final Builder nodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
            return this;
        }

        @Override
        public final Builder nodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus) {
            this.nodeUpdateStatus(nodeUpdateStatus.toString());
            return this;
        }

        public final void setNodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
        }

        public final Instant getNodeDeletionDate() {
            return this.nodeDeletionDate;
        }

        @Override
        public final Builder nodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
            return this;
        }

        public final void setNodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
        }

        public final Instant getNodeUpdateStartDate() {
            return this.nodeUpdateStartDate;
        }

        @Override
        public final Builder nodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
            return this;
        }

        public final void setNodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
        }

        public final Instant getNodeUpdateEndDate() {
            return this.nodeUpdateEndDate;
        }

        @Override
        public final Builder nodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
            return this;
        }

        public final void setNodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
        }

        public final String getNodeUpdateInitiatedByAsString() {
            return this.nodeUpdateInitiatedBy;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
            return this;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy(nodeUpdateInitiatedBy.toString());
            return this;
        }

        public final void setNodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
        }

        public final Instant getNodeUpdateInitiatedDate() {
            return this.nodeUpdateInitiatedDate;
        }

        @Override
        public final Builder nodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
            return this;
        }

        public final void setNodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
        }

        public final Instant getNodeUpdateStatusModifiedDate() {
            return this.nodeUpdateStatusModifiedDate;
        }

        @Override
        public final Builder nodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
            return this;
        }

        public final void setNodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
        }

        public NodeGroupMemberUpdateStatus build() {
            return new NodeGroupMemberUpdateStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeGroupMemberUpdateStatus> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder nodeUpdateStatus(String var1);

        public Builder nodeUpdateStatus(NodeUpdateStatus var1);

        public Builder nodeDeletionDate(Instant var1);

        public Builder nodeUpdateStartDate(Instant var1);

        public Builder nodeUpdateEndDate(Instant var1);

        public Builder nodeUpdateInitiatedBy(String var1);

        public Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy var1);

        public Builder nodeUpdateInitiatedDate(Instant var1);

        public Builder nodeUpdateStatusModifiedDate(Instant var1);
    }
}

