/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUpdateActionsResponse;
import software.amazon.awssdk.services.elasticache.model.UpdateAction;

public class DescribeUpdateActionsIterable
implements SdkIterable<DescribeUpdateActionsResponse> {
    private final ElastiCacheClient client;
    private final DescribeUpdateActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeUpdateActionsIterable(ElastiCacheClient client, DescribeUpdateActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeUpdateActionsResponseFetcher();
    }

    public Iterator<DescribeUpdateActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UpdateAction> updateActions() {
        Function<DescribeUpdateActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateActions() != null) {
                return response.updateActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeUpdateActionsResponseFetcher
    implements SyncPageFetcher<DescribeUpdateActionsResponse> {
        private DescribeUpdateActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUpdateActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeUpdateActionsResponse nextPage(DescribeUpdateActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUpdateActionsIterable.this.client.describeUpdateActions(DescribeUpdateActionsIterable.this.firstRequest);
            }
            return DescribeUpdateActionsIterable.this.client.describeUpdateActions((DescribeUpdateActionsRequest)((Object)DescribeUpdateActionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

