/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.RecurringCharge;
import software.amazon.awssdk.services.elasticache.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedCacheNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedCacheNode> {
    private static final SdkField<String> RESERVED_CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::reservedCacheNodeId)).setter(ReservedCacheNode.setter(Builder::reservedCacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodeId").build()}).build();
    private static final SdkField<String> RESERVED_CACHE_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::reservedCacheNodesOfferingId)).setter(ReservedCacheNode.setter(Builder::reservedCacheNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCacheNodesOfferingId").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::cacheNodeType)).setter(ReservedCacheNode.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReservedCacheNode.getter(ReservedCacheNode::startTime)).setter(ReservedCacheNode.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservedCacheNode.getter(ReservedCacheNode::duration)).setter(ReservedCacheNode.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ReservedCacheNode.getter(ReservedCacheNode::fixedPrice)).setter(ReservedCacheNode.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ReservedCacheNode.getter(ReservedCacheNode::usagePrice)).setter(ReservedCacheNode.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<Integer> CACHE_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservedCacheNode.getter(ReservedCacheNode::cacheNodeCount)).setter(ReservedCacheNode.setter(Builder::cacheNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeCount").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::productDescription)).setter(ReservedCacheNode.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::offeringType)).setter(ReservedCacheNode.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::state)).setter(ReservedCacheNode.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReservedCacheNode.getter(ReservedCacheNode::recurringCharges)).setter(ReservedCacheNode.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName("RecurringCharge").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharge").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedCacheNode.getter(ReservedCacheNode::reservationARN)).setter(ReservedCacheNode.setter(Builder::reservationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CACHE_NODE_ID_FIELD, RESERVED_CACHE_NODES_OFFERING_ID_FIELD, CACHE_NODE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CACHE_NODE_COUNT_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, STATE_FIELD, RECURRING_CHARGES_FIELD, RESERVATION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservedCacheNodeId;
    private final String reservedCacheNodesOfferingId;
    private final String cacheNodeType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final Integer cacheNodeCount;
    private final String productDescription;
    private final String offeringType;
    private final String state;
    private final List<RecurringCharge> recurringCharges;
    private final String reservationARN;

    private ReservedCacheNode(BuilderImpl builder) {
        this.reservedCacheNodeId = builder.reservedCacheNodeId;
        this.reservedCacheNodesOfferingId = builder.reservedCacheNodesOfferingId;
        this.cacheNodeType = builder.cacheNodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.cacheNodeCount = builder.cacheNodeCount;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.reservationARN = builder.reservationARN;
    }

    public String reservedCacheNodeId() {
        return this.reservedCacheNodeId;
    }

    public String reservedCacheNodesOfferingId() {
        return this.reservedCacheNodesOfferingId;
    }

    public String cacheNodeType() {
        return this.cacheNodeType;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public Integer cacheNodeCount() {
        return this.cacheNodeCount;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public String state() {
        return this.state;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public String reservationARN() {
        return this.reservationARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCacheNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedCacheNode)) {
            return false;
        }
        ReservedCacheNode other = (ReservedCacheNode)obj;
        return Objects.equals(this.reservedCacheNodeId(), other.reservedCacheNodeId()) && Objects.equals(this.reservedCacheNodesOfferingId(), other.reservedCacheNodesOfferingId()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.cacheNodeCount(), other.cacheNodeCount()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.reservationARN(), other.reservationARN());
    }

    public String toString() {
        return ToString.builder((String)"ReservedCacheNode").add("ReservedCacheNodeId", (Object)this.reservedCacheNodeId()).add("ReservedCacheNodesOfferingId", (Object)this.reservedCacheNodesOfferingId()).add("CacheNodeType", (Object)this.cacheNodeType()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CacheNodeCount", (Object)this.cacheNodeCount()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("State", (Object)this.state()).add("RecurringCharges", this.recurringCharges()).add("ReservationARN", (Object)this.reservationARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodeId()));
            }
            case "ReservedCacheNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedCacheNodesOfferingId()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CacheNodeCount": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeCount()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "ReservationARN": {
                return Optional.ofNullable(clazz.cast(this.reservationARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedCacheNode, T> g) {
        return obj -> g.apply((ReservedCacheNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedCacheNodeId;
        private String reservedCacheNodesOfferingId;
        private String cacheNodeType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private Integer cacheNodeCount;
        private String productDescription;
        private String offeringType;
        private String state;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String reservationARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedCacheNode model) {
            this.reservedCacheNodeId(model.reservedCacheNodeId);
            this.reservedCacheNodesOfferingId(model.reservedCacheNodesOfferingId);
            this.cacheNodeType(model.cacheNodeType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.cacheNodeCount(model.cacheNodeCount);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.state(model.state);
            this.recurringCharges(model.recurringCharges);
            this.reservationARN(model.reservationARN);
        }

        public final String getReservedCacheNodeId() {
            return this.reservedCacheNodeId;
        }

        @Override
        public final Builder reservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
            return this;
        }

        public final void setReservedCacheNodeId(String reservedCacheNodeId) {
            this.reservedCacheNodeId = reservedCacheNodeId;
        }

        public final String getReservedCacheNodesOfferingId() {
            return this.reservedCacheNodesOfferingId;
        }

        @Override
        public final Builder reservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
            return this;
        }

        public final void setReservedCacheNodesOfferingId(String reservedCacheNodesOfferingId) {
            this.reservedCacheNodesOfferingId = reservedCacheNodesOfferingId;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final Integer getCacheNodeCount() {
            return this.cacheNodeCount;
        }

        @Override
        public final Builder cacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
            return this;
        }

        public final void setCacheNodeCount(Integer cacheNodeCount) {
            this.cacheNodeCount = cacheNodeCount;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getReservationARN() {
            return this.reservationARN;
        }

        @Override
        public final Builder reservationARN(String reservationARN) {
            this.reservationARN = reservationARN;
            return this;
        }

        public final void setReservationARN(String reservationARN) {
            this.reservationARN = reservationARN;
        }

        public ReservedCacheNode build() {
            return new ReservedCacheNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedCacheNode> {
        public Builder reservedCacheNodeId(String var1);

        public Builder reservedCacheNodesOfferingId(String var1);

        public Builder cacheNodeType(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder cacheNodeCount(Integer var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder state(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder reservationARN(String var1);
    }
}

