/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeReplicationGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.ReplicationGroup;

public class DescribeReplicationGroupsPublisher
implements SdkPublisher<DescribeReplicationGroupsResponse> {
    private final ElastiCacheAsyncClient client;
    private final DescribeReplicationGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationGroupsPublisher(ElastiCacheAsyncClient client, DescribeReplicationGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationGroupsPublisher(ElastiCacheAsyncClient client, DescribeReplicationGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReplicationGroup> replicationGroups() {
        Function<DescribeReplicationGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationGroups() != null) {
                return response.replicationGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReplicationGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeReplicationGroupsPublisher resume(DescribeReplicationGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationGroupsPublisher(this.client, (DescribeReplicationGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReplicationGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReplicationGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationGroupsResponse> {
        private DescribeReplicationGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationGroupsResponse> nextPage(DescribeReplicationGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationGroupsPublisher.this.client.describeReplicationGroups(DescribeReplicationGroupsPublisher.this.firstRequest);
            }
            return DescribeReplicationGroupsPublisher.this.client.describeReplicationGroups((DescribeReplicationGroupsRequest)((Object)DescribeReplicationGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

