/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValue;
import software.amazon.awssdk.services.elasticache.model.CacheNodeTypeSpecificValueListCopier;
import software.amazon.awssdk.services.elasticache.model.ChangeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheNodeTypeSpecificParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheNodeTypeSpecificParameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::parameterName)).setter(CacheNodeTypeSpecificParameter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::description)).setter(CacheNodeTypeSpecificParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::source)).setter(CacheNodeTypeSpecificParameter.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::dataType)).setter(CacheNodeTypeSpecificParameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedValues").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::allowedValues)).setter(CacheNodeTypeSpecificParameter.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final SdkField<Boolean> IS_MODIFIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsModifiable").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::isModifiable)).setter(CacheNodeTypeSpecificParameter.setter(Builder::isModifiable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::minimumEngineVersion)).setter(CacheNodeTypeSpecificParameter.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final SdkField<List<CacheNodeTypeSpecificValue>> CACHE_NODE_TYPE_SPECIFIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodeTypeSpecificValues").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::cacheNodeTypeSpecificValues)).setter(CacheNodeTypeSpecificParameter.setter(Builder::cacheNodeTypeSpecificValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeTypeSpecificValues").build(), ListTrait.builder().memberLocationName("CacheNodeTypeSpecificValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheNodeTypeSpecificValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeTypeSpecificValue").build()}).build()).build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeType").getter(CacheNodeTypeSpecificParameter.getter(CacheNodeTypeSpecificParameter::changeTypeAsString)).setter(CacheNodeTypeSpecificParameter.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD, MINIMUM_ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_SPECIFIC_VALUES_FIELD, CHANGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CacheNodeTypeSpecificParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parameterName;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final Boolean isModifiable;
    private final String minimumEngineVersion;
    private final List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues;
    private final String changeType;

    private CacheNodeTypeSpecificParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.cacheNodeTypeSpecificValues = builder.cacheNodeTypeSpecificValues;
        this.changeType = builder.changeType;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final String description() {
        return this.description;
    }

    public final String source() {
        return this.source;
    }

    public final String dataType() {
        return this.dataType;
    }

    public final String allowedValues() {
        return this.allowedValues;
    }

    public final Boolean isModifiable() {
        return this.isModifiable;
    }

    public final String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public final boolean hasCacheNodeTypeSpecificValues() {
        return this.cacheNodeTypeSpecificValues != null && !(this.cacheNodeTypeSpecificValues instanceof SdkAutoConstructList);
    }

    public final List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues() {
        return this.cacheNodeTypeSpecificValues;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiable());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheNodeTypeSpecificValues() ? this.cacheNodeTypeSpecificValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheNodeTypeSpecificParameter)) {
            return false;
        }
        CacheNodeTypeSpecificParameter other = (CacheNodeTypeSpecificParameter)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.isModifiable(), other.isModifiable()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion()) && this.hasCacheNodeTypeSpecificValues() == other.hasCacheNodeTypeSpecificValues() && Objects.equals(this.cacheNodeTypeSpecificValues(), other.cacheNodeTypeSpecificValues()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CacheNodeTypeSpecificParameter").add("ParameterName", (Object)this.parameterName()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("DataType", (Object)this.dataType()).add("AllowedValues", (Object)this.allowedValues()).add("IsModifiable", (Object)this.isModifiable()).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).add("CacheNodeTypeSpecificValues", this.hasCacheNodeTypeSpecificValues() ? this.cacheNodeTypeSpecificValues() : null).add("ChangeType", (Object)this.changeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.ofNullable(clazz.cast(this.isModifiable()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
            case "CacheNodeTypeSpecificValues": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeTypeSpecificValues()));
            }
            case "ChangeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("DataType", DATA_TYPE_FIELD);
        map.put("AllowedValues", ALLOWED_VALUES_FIELD);
        map.put("IsModifiable", IS_MODIFIABLE_FIELD);
        map.put("MinimumEngineVersion", MINIMUM_ENGINE_VERSION_FIELD);
        map.put("CacheNodeTypeSpecificValues", CACHE_NODE_TYPE_SPECIFIC_VALUES_FIELD);
        map.put("ChangeType", CHANGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CacheNodeTypeSpecificParameter, T> g) {
        return obj -> g.apply((CacheNodeTypeSpecificParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private Boolean isModifiable;
        private String minimumEngineVersion;
        private List<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues = DefaultSdkAutoConstructList.getInstance();
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheNodeTypeSpecificParameter model) {
            this.parameterName(model.parameterName);
            this.description(model.description);
            this.source(model.source);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.cacheNodeTypeSpecificValues(model.cacheNodeTypeSpecificValues);
            this.changeType(model.changeType);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final List<CacheNodeTypeSpecificValue.Builder> getCacheNodeTypeSpecificValues() {
            List<CacheNodeTypeSpecificValue.Builder> result = CacheNodeTypeSpecificValueListCopier.copyToBuilder(this.cacheNodeTypeSpecificValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCacheNodeTypeSpecificValues(Collection<CacheNodeTypeSpecificValue.BuilderImpl> cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues = CacheNodeTypeSpecificValueListCopier.copyFromBuilder(cacheNodeTypeSpecificValues);
        }

        @Override
        public final Builder cacheNodeTypeSpecificValues(Collection<CacheNodeTypeSpecificValue> cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues = CacheNodeTypeSpecificValueListCopier.copy(cacheNodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificValues(CacheNodeTypeSpecificValue ... cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues(Arrays.asList(cacheNodeTypeSpecificValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeTypeSpecificValues(Consumer<CacheNodeTypeSpecificValue.Builder> ... cacheNodeTypeSpecificValues) {
            this.cacheNodeTypeSpecificValues(Stream.of(cacheNodeTypeSpecificValues).map(c -> (CacheNodeTypeSpecificValue)((CacheNodeTypeSpecificValue.Builder)CacheNodeTypeSpecificValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public CacheNodeTypeSpecificParameter build() {
            return new CacheNodeTypeSpecificParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheNodeTypeSpecificParameter> {
        public Builder parameterName(String var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(Boolean var1);

        public Builder minimumEngineVersion(String var1);

        public Builder cacheNodeTypeSpecificValues(Collection<CacheNodeTypeSpecificValue> var1);

        public Builder cacheNodeTypeSpecificValues(CacheNodeTypeSpecificValue ... var1);

        public Builder cacheNodeTypeSpecificValues(Consumer<CacheNodeTypeSpecificValue.Builder> ... var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);
    }
}

