/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCache;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServerlessCachesResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeServerlessCachesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeServerlessCachesResponse.getter(DescribeServerlessCachesResponse::nextToken)).setter(DescribeServerlessCachesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServerlessCache>> SERVERLESS_CACHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServerlessCaches").getter(DescribeServerlessCachesResponse.getter(DescribeServerlessCachesResponse::serverlessCaches)).setter(DescribeServerlessCachesResponse.setter(Builder::serverlessCaches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCaches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerlessCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVERLESS_CACHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServerlessCachesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ServerlessCache> serverlessCaches;

    private DescribeServerlessCachesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverlessCaches = builder.serverlessCaches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServerlessCaches() {
        return this.serverlessCaches != null && !(this.serverlessCaches instanceof SdkAutoConstructList);
    }

    public final List<ServerlessCache> serverlessCaches() {
        return this.serverlessCaches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerlessCaches() ? this.serverlessCaches() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCachesResponse)) {
            return false;
        }
        DescribeServerlessCachesResponse other = (DescribeServerlessCachesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServerlessCaches() == other.hasServerlessCaches() && Objects.equals(this.serverlessCaches(), other.serverlessCaches());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServerlessCachesResponse").add("NextToken", (Object)this.nextToken()).add("ServerlessCaches", this.hasServerlessCaches() ? this.serverlessCaches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServerlessCaches": {
                return Optional.ofNullable(clazz.cast(this.serverlessCaches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServerlessCaches", SERVERLESS_CACHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCachesResponse, T> g) {
        return obj -> g.apply((DescribeServerlessCachesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServerlessCache> serverlessCaches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCachesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serverlessCaches(model.serverlessCaches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServerlessCache.Builder> getServerlessCaches() {
            List<ServerlessCache.Builder> result = ServerlessCacheListCopier.copyToBuilder(this.serverlessCaches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerlessCaches(Collection<ServerlessCache.BuilderImpl> serverlessCaches) {
            this.serverlessCaches = ServerlessCacheListCopier.copyFromBuilder(serverlessCaches);
        }

        @Override
        public final Builder serverlessCaches(Collection<ServerlessCache> serverlessCaches) {
            this.serverlessCaches = ServerlessCacheListCopier.copy(serverlessCaches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCaches(ServerlessCache ... serverlessCaches) {
            this.serverlessCaches(Arrays.asList(serverlessCaches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCaches(Consumer<ServerlessCache.Builder> ... serverlessCaches) {
            this.serverlessCaches(Stream.of(serverlessCaches).map(c -> (ServerlessCache)((ServerlessCache.Builder)ServerlessCache.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServerlessCachesResponse build() {
            return new DescribeServerlessCachesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServerlessCachesResponse> {
        public Builder nextToken(String var1);

        public Builder serverlessCaches(Collection<ServerlessCache> var1);

        public Builder serverlessCaches(ServerlessCache ... var1);

        public Builder serverlessCaches(Consumer<ServerlessCache.Builder> ... var1);
    }
}

