/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupNameListCopier;
import software.amazon.awssdk.services.elasticache.model.ClusterMode;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.IpDiscovery;
import software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequest;
import software.amazon.awssdk.services.elasticache.model.LogDeliveryConfigurationRequestListCopier;
import software.amazon.awssdk.services.elasticache.model.NetworkType;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfiguration;
import software.amazon.awssdk.services.elasticache.model.NodeGroupConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SnapshotArnsListCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode;
import software.amazon.awssdk.services.elasticache.model.UserGroupIdListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateReplicationGroupRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicationGroupId)).setter(CreateReplicationGroupRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupDescription").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicationGroupDescription)).setter(CreateReplicationGroupRequest.setter(Builder::replicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription").build()}).build();
    private static final SdkField<String> GLOBAL_REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalReplicationGroupId").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::globalReplicationGroupId)).setter(CreateReplicationGroupRequest.setter(Builder::globalReplicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroupId").build()}).build();
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryClusterId").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::primaryClusterId)).setter(CreateReplicationGroupRequest.setter(Builder::primaryClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()}).build();
    private static final SdkField<Boolean> AUTOMATIC_FAILOVER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutomaticFailoverEnabled").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::automaticFailoverEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::automaticFailoverEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverEnabled").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZEnabled").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::multiAZEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::multiAZEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZEnabled").build()}).build();
    private static final SdkField<Integer> NUM_CACHE_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumCacheClusters").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::numCacheClusters)).setter(CreateReplicationGroupRequest.setter(Builder::numCacheClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheClusters").build()}).build();
    private static final SdkField<List<String>> PREFERRED_CACHE_CLUSTER_A_ZS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreferredCacheClusterAZs").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::preferredCacheClusterAZs)).setter(CreateReplicationGroupRequest.setter(Builder::preferredCacheClusterAZs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredCacheClusterAZs").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUM_NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumNodeGroups").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::numNodeGroups)).setter(CreateReplicationGroupRequest.setter(Builder::numNodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumNodeGroups").build()}).build();
    private static final SdkField<Integer> REPLICAS_PER_NODE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicasPerNodeGroup").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::replicasPerNodeGroup)).setter(CreateReplicationGroupRequest.setter(Builder::replicasPerNodeGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicasPerNodeGroup").build()}).build();
    private static final SdkField<List<NodeGroupConfiguration>> NODE_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroupConfiguration").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::nodeGroupConfiguration)).setter(CreateReplicationGroupRequest.setter(Builder::nodeGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build(), ListTrait.builder().memberLocationName("NodeGroupConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeGroupConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupConfiguration").build()}).build()).build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheNodeType)).setter(CreateReplicationGroupRequest.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::engine)).setter(CreateReplicationGroupRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::engineVersion)).setter(CreateReplicationGroupRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupName").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheParameterGroupName)).setter(CreateReplicationGroupRequest.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSubnetGroupName").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheSubnetGroupName)).setter(CreateReplicationGroupRequest.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<List<String>> CACHE_SECURITY_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheSecurityGroupNames").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::cacheSecurityGroupNames)).setter(CreateReplicationGroupRequest.setter(Builder::cacheSecurityGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupNames").build(), ListTrait.builder().memberLocationName("CacheSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::securityGroupIds)).setter(CreateReplicationGroupRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::tags)).setter(CreateReplicationGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SNAPSHOT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotArns").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotArns)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArns").build(), ListTrait.builder().memberLocationName("SnapshotArn").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotName").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotName)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::preferredMaintenanceWindow)).setter(CreateReplicationGroupRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::port)).setter(CreateReplicationGroupRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> NOTIFICATION_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTopicArn").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::notificationTopicArn)).setter(CreateReplicationGroupRequest.setter(Builder::notificationTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTopicArn").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::autoMinorVersionUpgrade)).setter(CreateReplicationGroupRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotRetentionLimit)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::snapshotWindow)).setter(CreateReplicationGroupRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthToken").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::authToken)).setter(CreateReplicationGroupRequest.setter(Builder::authToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::transitEncryptionEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> AT_REST_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AtRestEncryptionEnabled").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::atRestEncryptionEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::atRestEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AtRestEncryptionEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::kmsKeyId)).setter(CreateReplicationGroupRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<String>> USER_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserGroupIds").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::userGroupIds)).setter(CreateReplicationGroupRequest.setter(Builder::userGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LogDeliveryConfigurationRequest>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogDeliveryConfigurations").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::logDeliveryConfigurations)).setter(CreateReplicationGroupRequest.setter(Builder::logDeliveryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(), ListTrait.builder().memberLocationName("LogDeliveryConfigurationRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogDeliveryConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurationRequest").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DATA_TIERING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataTieringEnabled").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::dataTieringEnabled)).setter(CreateReplicationGroupRequest.setter(Builder::dataTieringEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTieringEnabled").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::networkTypeAsString)).setter(CreateReplicationGroupRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpDiscovery").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::ipDiscoveryAsString)).setter(CreateReplicationGroupRequest.setter(Builder::ipDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()}).build();
    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitEncryptionMode").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::transitEncryptionModeAsString)).setter(CreateReplicationGroupRequest.setter(Builder::transitEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build()}).build();
    private static final SdkField<String> CLUSTER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterMode").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::clusterModeAsString)).setter(CreateReplicationGroupRequest.setter(Builder::clusterMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMode").build()}).build();
    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheSnapshotName").getter(CreateReplicationGroupRequest.getter(CreateReplicationGroupRequest::serverlessCacheSnapshotName)).setter(CreateReplicationGroupRequest.setter(Builder::serverlessCacheSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_DESCRIPTION_FIELD, GLOBAL_REPLICATION_GROUP_ID_FIELD, PRIMARY_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_ENABLED_FIELD, MULTI_AZ_ENABLED_FIELD, NUM_CACHE_CLUSTERS_FIELD, PREFERRED_CACHE_CLUSTER_A_ZS_FIELD, NUM_NODE_GROUPS_FIELD, REPLICAS_PER_NODE_GROUP_FIELD, NODE_GROUP_CONFIGURATION_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, CACHE_SECURITY_GROUP_NAMES_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, SNAPSHOT_ARNS_FIELD, SNAPSHOT_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PORT_FIELD, NOTIFICATION_TOPIC_ARN_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, AUTH_TOKEN_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, AT_REST_ENCRYPTION_ENABLED_FIELD, KMS_KEY_ID_FIELD, USER_GROUP_IDS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, DATA_TIERING_ENABLED_FIELD, NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD, CLUSTER_MODE_FIELD, SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateReplicationGroupRequest.memberNameToFieldInitializer();
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String globalReplicationGroupId;
    private final String primaryClusterId;
    private final Boolean automaticFailoverEnabled;
    private final Boolean multiAZEnabled;
    private final Integer numCacheClusters;
    private final List<String> preferredCacheClusterAZs;
    private final Integer numNodeGroups;
    private final Integer replicasPerNodeGroup;
    private final List<NodeGroupConfiguration> nodeGroupConfiguration;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final List<String> cacheSecurityGroupNames;
    private final List<String> securityGroupIds;
    private final List<Tag> tags;
    private final List<String> snapshotArns;
    private final String snapshotName;
    private final String preferredMaintenanceWindow;
    private final Integer port;
    private final String notificationTopicArn;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final String authToken;
    private final Boolean transitEncryptionEnabled;
    private final Boolean atRestEncryptionEnabled;
    private final String kmsKeyId;
    private final List<String> userGroupIds;
    private final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations;
    private final Boolean dataTieringEnabled;
    private final String networkType;
    private final String ipDiscovery;
    private final String transitEncryptionMode;
    private final String clusterMode;
    private final String serverlessCacheSnapshotName;

    private CreateReplicationGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.globalReplicationGroupId = builder.globalReplicationGroupId;
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverEnabled = builder.automaticFailoverEnabled;
        this.multiAZEnabled = builder.multiAZEnabled;
        this.numCacheClusters = builder.numCacheClusters;
        this.preferredCacheClusterAZs = builder.preferredCacheClusterAZs;
        this.numNodeGroups = builder.numNodeGroups;
        this.replicasPerNodeGroup = builder.replicasPerNodeGroup;
        this.nodeGroupConfiguration = builder.nodeGroupConfiguration;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.cacheSecurityGroupNames = builder.cacheSecurityGroupNames;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.snapshotArns = builder.snapshotArns;
        this.snapshotName = builder.snapshotName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.port = builder.port;
        this.notificationTopicArn = builder.notificationTopicArn;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.authToken = builder.authToken;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.atRestEncryptionEnabled = builder.atRestEncryptionEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.userGroupIds = builder.userGroupIds;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.dataTieringEnabled = builder.dataTieringEnabled;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.clusterMode = builder.clusterMode;
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public final String globalReplicationGroupId() {
        return this.globalReplicationGroupId;
    }

    public final String primaryClusterId() {
        return this.primaryClusterId;
    }

    public final Boolean automaticFailoverEnabled() {
        return this.automaticFailoverEnabled;
    }

    public final Boolean multiAZEnabled() {
        return this.multiAZEnabled;
    }

    public final Integer numCacheClusters() {
        return this.numCacheClusters;
    }

    public final boolean hasPreferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs != null && !(this.preferredCacheClusterAZs instanceof SdkAutoConstructList);
    }

    public final List<String> preferredCacheClusterAZs() {
        return this.preferredCacheClusterAZs;
    }

    public final Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public final Integer replicasPerNodeGroup() {
        return this.replicasPerNodeGroup;
    }

    public final boolean hasNodeGroupConfiguration() {
        return this.nodeGroupConfiguration != null && !(this.nodeGroupConfiguration instanceof SdkAutoConstructList);
    }

    public final List<NodeGroupConfiguration> nodeGroupConfiguration() {
        return this.nodeGroupConfiguration;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public final String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public final boolean hasCacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames != null && !(this.cacheSecurityGroupNames instanceof SdkAutoConstructList);
    }

    public final List<String> cacheSecurityGroupNames() {
        return this.cacheSecurityGroupNames;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasSnapshotArns() {
        return this.snapshotArns != null && !(this.snapshotArns instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotArns() {
        return this.snapshotArns;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Integer port() {
        return this.port;
    }

    public final String notificationTopicArn() {
        return this.notificationTopicArn;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final String authToken() {
        return this.authToken;
    }

    public final Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public final Boolean atRestEncryptionEnabled() {
        return this.atRestEncryptionEnabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasUserGroupIds() {
        return this.userGroupIds != null && !(this.userGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> userGroupIds() {
        return this.userGroupIds;
    }

    public final boolean hasLogDeliveryConfigurations() {
        return this.logDeliveryConfigurations != null && !(this.logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<LogDeliveryConfigurationRequest> logDeliveryConfigurations() {
        return this.logDeliveryConfigurations;
    }

    public final Boolean dataTieringEnabled() {
        return this.dataTieringEnabled;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(this.ipDiscovery);
    }

    public final String ipDiscoveryAsString() {
        return this.ipDiscovery;
    }

    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(this.transitEncryptionMode);
    }

    public final String transitEncryptionModeAsString() {
        return this.transitEncryptionMode;
    }

    public final ClusterMode clusterMode() {
        return ClusterMode.fromValue(this.clusterMode);
    }

    public final String clusterModeAsString() {
        return this.clusterMode;
    }

    public final String serverlessCacheSnapshotName() {
        return this.serverlessCacheSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalReplicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheClusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreferredCacheClusterAZs() ? this.preferredCacheClusterAZs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicasPerNodeGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeGroupConfiguration() ? this.nodeGroupConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheSecurityGroupNames() ? this.cacheSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotArns() ? this.snapshotArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.authToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.atRestEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroupIds() ? this.userGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTieringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipDiscoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheSnapshotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationGroupRequest)) {
            return false;
        }
        CreateReplicationGroupRequest other = (CreateReplicationGroupRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.globalReplicationGroupId(), other.globalReplicationGroupId()) && Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverEnabled(), other.automaticFailoverEnabled()) && Objects.equals(this.multiAZEnabled(), other.multiAZEnabled()) && Objects.equals(this.numCacheClusters(), other.numCacheClusters()) && this.hasPreferredCacheClusterAZs() == other.hasPreferredCacheClusterAZs() && Objects.equals(this.preferredCacheClusterAZs(), other.preferredCacheClusterAZs()) && Objects.equals(this.numNodeGroups(), other.numNodeGroups()) && Objects.equals(this.replicasPerNodeGroup(), other.replicasPerNodeGroup()) && this.hasNodeGroupConfiguration() == other.hasNodeGroupConfiguration() && Objects.equals(this.nodeGroupConfiguration(), other.nodeGroupConfiguration()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && this.hasCacheSecurityGroupNames() == other.hasCacheSecurityGroupNames() && Objects.equals(this.cacheSecurityGroupNames(), other.cacheSecurityGroupNames()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasSnapshotArns() == other.hasSnapshotArns() && Objects.equals(this.snapshotArns(), other.snapshotArns()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.notificationTopicArn(), other.notificationTopicArn()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.authToken(), other.authToken()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.atRestEncryptionEnabled(), other.atRestEncryptionEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasUserGroupIds() == other.hasUserGroupIds() && Objects.equals(this.userGroupIds(), other.userGroupIds()) && this.hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations() && Objects.equals(this.logDeliveryConfigurations(), other.logDeliveryConfigurations()) && Objects.equals(this.dataTieringEnabled(), other.dataTieringEnabled()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.ipDiscoveryAsString(), other.ipDiscoveryAsString()) && Objects.equals(this.transitEncryptionModeAsString(), other.transitEncryptionModeAsString()) && Objects.equals(this.clusterModeAsString(), other.clusterModeAsString()) && Objects.equals(this.serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicationGroupRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("GlobalReplicationGroupId", (Object)this.globalReplicationGroupId()).add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverEnabled", (Object)this.automaticFailoverEnabled()).add("MultiAZEnabled", (Object)this.multiAZEnabled()).add("NumCacheClusters", (Object)this.numCacheClusters()).add("PreferredCacheClusterAZs", this.hasPreferredCacheClusterAZs() ? this.preferredCacheClusterAZs() : null).add("NumNodeGroups", (Object)this.numNodeGroups()).add("ReplicasPerNodeGroup", (Object)this.replicasPerNodeGroup()).add("NodeGroupConfiguration", this.hasNodeGroupConfiguration() ? this.nodeGroupConfiguration() : null).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("CacheSecurityGroupNames", this.hasCacheSecurityGroupNames() ? this.cacheSecurityGroupNames() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("SnapshotArns", this.hasSnapshotArns() ? this.snapshotArns() : null).add("SnapshotName", (Object)this.snapshotName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("Port", (Object)this.port()).add("NotificationTopicArn", (Object)this.notificationTopicArn()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("AuthToken", (Object)this.authToken()).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("AtRestEncryptionEnabled", (Object)this.atRestEncryptionEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("UserGroupIds", this.hasUserGroupIds() ? this.userGroupIds() : null).add("LogDeliveryConfigurations", this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null).add("DataTieringEnabled", (Object)this.dataTieringEnabled()).add("NetworkType", (Object)this.networkTypeAsString()).add("IpDiscovery", (Object)this.ipDiscoveryAsString()).add("TransitEncryptionMode", (Object)this.transitEncryptionModeAsString()).add("ClusterMode", (Object)this.clusterModeAsString()).add("ServerlessCacheSnapshotName", (Object)this.serverlessCacheSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupDescription()));
            }
            case "GlobalReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.globalReplicationGroupId()));
            }
            case "PrimaryClusterId": {
                return Optional.ofNullable(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverEnabled": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverEnabled()));
            }
            case "MultiAZEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiAZEnabled()));
            }
            case "NumCacheClusters": {
                return Optional.ofNullable(clazz.cast(this.numCacheClusters()));
            }
            case "PreferredCacheClusterAZs": {
                return Optional.ofNullable(clazz.cast(this.preferredCacheClusterAZs()));
            }
            case "NumNodeGroups": {
                return Optional.ofNullable(clazz.cast(this.numNodeGroups()));
            }
            case "ReplicasPerNodeGroup": {
                return Optional.ofNullable(clazz.cast(this.replicasPerNodeGroup()));
            }
            case "NodeGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupConfiguration()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "CacheSecurityGroupNames": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupNames()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SnapshotArns": {
                return Optional.ofNullable(clazz.cast(this.snapshotArns()));
            }
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "NotificationTopicArn": {
                return Optional.ofNullable(clazz.cast(this.notificationTopicArn()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "AuthToken": {
                return Optional.ofNullable(clazz.cast(this.authToken()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "AtRestEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.atRestEncryptionEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "UserGroupIds": {
                return Optional.ofNullable(clazz.cast(this.userGroupIds()));
            }
            case "LogDeliveryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfigurations()));
            }
            case "DataTieringEnabled": {
                return Optional.ofNullable(clazz.cast(this.dataTieringEnabled()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "IpDiscovery": {
                return Optional.ofNullable(clazz.cast(this.ipDiscoveryAsString()));
            }
            case "TransitEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionModeAsString()));
            }
            case "ClusterMode": {
                return Optional.ofNullable(clazz.cast(this.clusterModeAsString()));
            }
            case "ServerlessCacheSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheSnapshotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationGroupId", REPLICATION_GROUP_ID_FIELD);
        map.put("ReplicationGroupDescription", REPLICATION_GROUP_DESCRIPTION_FIELD);
        map.put("GlobalReplicationGroupId", GLOBAL_REPLICATION_GROUP_ID_FIELD);
        map.put("PrimaryClusterId", PRIMARY_CLUSTER_ID_FIELD);
        map.put("AutomaticFailoverEnabled", AUTOMATIC_FAILOVER_ENABLED_FIELD);
        map.put("MultiAZEnabled", MULTI_AZ_ENABLED_FIELD);
        map.put("NumCacheClusters", NUM_CACHE_CLUSTERS_FIELD);
        map.put("PreferredCacheClusterAZs", PREFERRED_CACHE_CLUSTER_A_ZS_FIELD);
        map.put("NumNodeGroups", NUM_NODE_GROUPS_FIELD);
        map.put("ReplicasPerNodeGroup", REPLICAS_PER_NODE_GROUP_FIELD);
        map.put("NodeGroupConfiguration", NODE_GROUP_CONFIGURATION_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("CacheParameterGroupName", CACHE_PARAMETER_GROUP_NAME_FIELD);
        map.put("CacheSubnetGroupName", CACHE_SUBNET_GROUP_NAME_FIELD);
        map.put("CacheSecurityGroupNames", CACHE_SECURITY_GROUP_NAMES_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SnapshotArns", SNAPSHOT_ARNS_FIELD);
        map.put("SnapshotName", SNAPSHOT_NAME_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("NotificationTopicArn", NOTIFICATION_TOPIC_ARN_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
        map.put("SnapshotWindow", SNAPSHOT_WINDOW_FIELD);
        map.put("AuthToken", AUTH_TOKEN_FIELD);
        map.put("TransitEncryptionEnabled", TRANSIT_ENCRYPTION_ENABLED_FIELD);
        map.put("AtRestEncryptionEnabled", AT_REST_ENCRYPTION_ENABLED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("UserGroupIds", USER_GROUP_IDS_FIELD);
        map.put("LogDeliveryConfigurations", LOG_DELIVERY_CONFIGURATIONS_FIELD);
        map.put("DataTieringEnabled", DATA_TIERING_ENABLED_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("IpDiscovery", IP_DISCOVERY_FIELD);
        map.put("TransitEncryptionMode", TRANSIT_ENCRYPTION_MODE_FIELD);
        map.put("ClusterMode", CLUSTER_MODE_FIELD);
        map.put("ServerlessCacheSnapshotName", SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationGroupRequest, T> g) {
        return obj -> g.apply((CreateReplicationGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String globalReplicationGroupId;
        private String primaryClusterId;
        private Boolean automaticFailoverEnabled;
        private Boolean multiAZEnabled;
        private Integer numCacheClusters;
        private List<String> preferredCacheClusterAZs = DefaultSdkAutoConstructList.getInstance();
        private Integer numNodeGroups;
        private Integer replicasPerNodeGroup;
        private List<NodeGroupConfiguration> nodeGroupConfiguration = DefaultSdkAutoConstructList.getInstance();
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private List<String> cacheSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> snapshotArns = DefaultSdkAutoConstructList.getInstance();
        private String snapshotName;
        private String preferredMaintenanceWindow;
        private Integer port;
        private String notificationTopicArn;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private String authToken;
        private Boolean transitEncryptionEnabled;
        private Boolean atRestEncryptionEnabled;
        private String kmsKeyId;
        private List<String> userGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<LogDeliveryConfigurationRequest> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean dataTieringEnabled;
        private String networkType;
        private String ipDiscovery;
        private String transitEncryptionMode;
        private String clusterMode;
        private String serverlessCacheSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationGroupRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.globalReplicationGroupId(model.globalReplicationGroupId);
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverEnabled(model.automaticFailoverEnabled);
            this.multiAZEnabled(model.multiAZEnabled);
            this.numCacheClusters(model.numCacheClusters);
            this.preferredCacheClusterAZs(model.preferredCacheClusterAZs);
            this.numNodeGroups(model.numNodeGroups);
            this.replicasPerNodeGroup(model.replicasPerNodeGroup);
            this.nodeGroupConfiguration(model.nodeGroupConfiguration);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.cacheSecurityGroupNames(model.cacheSecurityGroupNames);
            this.securityGroupIds(model.securityGroupIds);
            this.tags(model.tags);
            this.snapshotArns(model.snapshotArns);
            this.snapshotName(model.snapshotName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.port(model.port);
            this.notificationTopicArn(model.notificationTopicArn);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.authToken(model.authToken);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.atRestEncryptionEnabled(model.atRestEncryptionEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.userGroupIds(model.userGroupIds);
            this.logDeliveryConfigurations(model.logDeliveryConfigurations);
            this.dataTieringEnabled(model.dataTieringEnabled);
            this.networkType(model.networkType);
            this.ipDiscovery(model.ipDiscovery);
            this.transitEncryptionMode(model.transitEncryptionMode);
            this.clusterMode(model.clusterMode);
            this.serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final String getGlobalReplicationGroupId() {
            return this.globalReplicationGroupId;
        }

        public final void setGlobalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
        }

        @Override
        public final Builder globalReplicationGroupId(String globalReplicationGroupId) {
            this.globalReplicationGroupId = globalReplicationGroupId;
            return this;
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final Boolean getAutomaticFailoverEnabled() {
            return this.automaticFailoverEnabled;
        }

        public final void setAutomaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
        }

        @Override
        public final Builder automaticFailoverEnabled(Boolean automaticFailoverEnabled) {
            this.automaticFailoverEnabled = automaticFailoverEnabled;
            return this;
        }

        public final Boolean getMultiAZEnabled() {
            return this.multiAZEnabled;
        }

        public final void setMultiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
        }

        @Override
        public final Builder multiAZEnabled(Boolean multiAZEnabled) {
            this.multiAZEnabled = multiAZEnabled;
            return this;
        }

        public final Integer getNumCacheClusters() {
            return this.numCacheClusters;
        }

        public final void setNumCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
        }

        @Override
        public final Builder numCacheClusters(Integer numCacheClusters) {
            this.numCacheClusters = numCacheClusters;
            return this;
        }

        public final Collection<String> getPreferredCacheClusterAZs() {
            if (this.preferredCacheClusterAZs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.preferredCacheClusterAZs;
        }

        public final void setPreferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
        }

        @Override
        public final Builder preferredCacheClusterAZs(Collection<String> preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs = AvailabilityZonesListCopier.copy(preferredCacheClusterAZs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preferredCacheClusterAZs(String ... preferredCacheClusterAZs) {
            this.preferredCacheClusterAZs(Arrays.asList(preferredCacheClusterAZs));
            return this;
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final Integer getReplicasPerNodeGroup() {
            return this.replicasPerNodeGroup;
        }

        public final void setReplicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
        }

        @Override
        public final Builder replicasPerNodeGroup(Integer replicasPerNodeGroup) {
            this.replicasPerNodeGroup = replicasPerNodeGroup;
            return this;
        }

        public final List<NodeGroupConfiguration.Builder> getNodeGroupConfiguration() {
            List<NodeGroupConfiguration.Builder> result = NodeGroupConfigurationListCopier.copyToBuilder(this.nodeGroupConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeGroupConfiguration(Collection<NodeGroupConfiguration.BuilderImpl> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copyFromBuilder(nodeGroupConfiguration);
        }

        @Override
        public final Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> nodeGroupConfiguration) {
            this.nodeGroupConfiguration = NodeGroupConfigurationListCopier.copy(nodeGroupConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(NodeGroupConfiguration ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Arrays.asList(nodeGroupConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> ... nodeGroupConfiguration) {
            this.nodeGroupConfiguration(Stream.of(nodeGroupConfiguration).map(c -> (NodeGroupConfiguration)((NodeGroupConfiguration.Builder)NodeGroupConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final Collection<String> getCacheSecurityGroupNames() {
            if (this.cacheSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheSecurityGroupNames;
        }

        public final void setCacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
        }

        @Override
        public final Builder cacheSecurityGroupNames(Collection<String> cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames = CacheSecurityGroupNameListCopier.copy(cacheSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroupNames(String ... cacheSecurityGroupNames) {
            this.cacheSecurityGroupNames(Arrays.asList(cacheSecurityGroupNames));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSnapshotArns() {
            if (this.snapshotArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotArns;
        }

        public final void setSnapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
        }

        @Override
        public final Builder snapshotArns(Collection<String> snapshotArns) {
            this.snapshotArns = SnapshotArnsListCopier.copy(snapshotArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotArns(String ... snapshotArns) {
            this.snapshotArns(Arrays.asList(snapshotArns));
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNotificationTopicArn() {
            return this.notificationTopicArn;
        }

        public final void setNotificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
        }

        @Override
        public final Builder notificationTopicArn(String notificationTopicArn) {
            this.notificationTopicArn = notificationTopicArn;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAuthToken() {
            return this.authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final Boolean getAtRestEncryptionEnabled() {
            return this.atRestEncryptionEnabled;
        }

        public final void setAtRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
        }

        @Override
        public final Builder atRestEncryptionEnabled(Boolean atRestEncryptionEnabled) {
            this.atRestEncryptionEnabled = atRestEncryptionEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getUserGroupIds() {
            if (this.userGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroupIds;
        }

        public final void setUserGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListInputCopier.copy(userGroupIds);
        }

        @Override
        public final Builder userGroupIds(Collection<String> userGroupIds) {
            this.userGroupIds = UserGroupIdListInputCopier.copy(userGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroupIds(String ... userGroupIds) {
            this.userGroupIds(Arrays.asList(userGroupIds));
            return this;
        }

        public final List<LogDeliveryConfigurationRequest.Builder> getLogDeliveryConfigurations() {
            List<LogDeliveryConfigurationRequest.Builder> result = LogDeliveryConfigurationRequestListCopier.copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = LogDeliveryConfigurationRequestListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder> ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Stream.of(logDeliveryConfigurations).map(c -> (LogDeliveryConfigurationRequest)((LogDeliveryConfigurationRequest.Builder)LogDeliveryConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDataTieringEnabled() {
            return this.dataTieringEnabled;
        }

        public final void setDataTieringEnabled(Boolean dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
        }

        @Override
        public final Builder dataTieringEnabled(Boolean dataTieringEnabled) {
            this.dataTieringEnabled = dataTieringEnabled;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return this.ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public final String getTransitEncryptionMode() {
            return this.transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final String getClusterMode() {
            return this.clusterMode;
        }

        public final void setClusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
        }

        @Override
        public final Builder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        @Override
        public final Builder clusterMode(ClusterMode clusterMode) {
            this.clusterMode(clusterMode == null ? null : clusterMode.toString());
            return this;
        }

        public final String getServerlessCacheSnapshotName() {
            return this.serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationGroupRequest build() {
            return new CreateReplicationGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationGroupRequest> {
        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder globalReplicationGroupId(String var1);

        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverEnabled(Boolean var1);

        public Builder multiAZEnabled(Boolean var1);

        public Builder numCacheClusters(Integer var1);

        public Builder preferredCacheClusterAZs(Collection<String> var1);

        public Builder preferredCacheClusterAZs(String ... var1);

        public Builder numNodeGroups(Integer var1);

        public Builder replicasPerNodeGroup(Integer var1);

        public Builder nodeGroupConfiguration(Collection<NodeGroupConfiguration> var1);

        public Builder nodeGroupConfiguration(NodeGroupConfiguration ... var1);

        public Builder nodeGroupConfiguration(Consumer<NodeGroupConfiguration.Builder> ... var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder cacheSecurityGroupNames(Collection<String> var1);

        public Builder cacheSecurityGroupNames(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder snapshotArns(Collection<String> var1);

        public Builder snapshotArns(String ... var1);

        public Builder snapshotName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder port(Integer var1);

        public Builder notificationTopicArn(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder authToken(String var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder atRestEncryptionEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder userGroupIds(Collection<String> var1);

        public Builder userGroupIds(String ... var1);

        public Builder logDeliveryConfigurations(Collection<LogDeliveryConfigurationRequest> var1);

        public Builder logDeliveryConfigurations(LogDeliveryConfigurationRequest ... var1);

        public Builder logDeliveryConfigurations(Consumer<LogDeliveryConfigurationRequest.Builder> ... var1);

        public Builder dataTieringEnabled(Boolean var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder ipDiscovery(String var1);

        public Builder ipDiscovery(IpDiscovery var1);

        public Builder transitEncryptionMode(String var1);

        public Builder transitEncryptionMode(TransitEncryptionMode var1);

        public Builder clusterMode(String var1);

        public Builder clusterMode(ClusterMode var1);

        public Builder serverlessCacheSnapshotName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

