/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.CacheNodeIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration;
import software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingModifiedValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingModifiedValues> {
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumCacheNodes").getter(PendingModifiedValues.getter(PendingModifiedValues::numCacheNodes)).setter(PendingModifiedValues.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheNodeIdsToRemove").getter(PendingModifiedValues.getter(PendingModifiedValues::cacheNodeIdsToRemove)).setter(PendingModifiedValues.setter(Builder::cacheNodeIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToRemove").build(), ListTrait.builder().memberLocationName("CacheNodeId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(PendingModifiedValues.getter(PendingModifiedValues::engineVersion)).setter(PendingModifiedValues.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(PendingModifiedValues.getter(PendingModifiedValues::cacheNodeType)).setter(PendingModifiedValues.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthTokenStatus").getter(PendingModifiedValues.getter(PendingModifiedValues::authTokenStatusAsString)).setter(PendingModifiedValues.setter(Builder::authTokenStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()}).build();
    private static final SdkField<List<PendingLogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogDeliveryConfigurations").getter(PendingModifiedValues.getter(PendingModifiedValues::logDeliveryConfigurations)).setter(PendingModifiedValues.setter(Builder::logDeliveryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingLogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(PendingModifiedValues.getter(PendingModifiedValues::transitEncryptionEnabled)).setter(PendingModifiedValues.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitEncryptionMode").getter(PendingModifiedValues.getter(PendingModifiedValues::transitEncryptionModeAsString)).setter(PendingModifiedValues.setter(Builder::transitEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_CACHE_NODES_FIELD, CACHE_NODE_IDS_TO_REMOVE_FIELD, ENGINE_VERSION_FIELD, CACHE_NODE_TYPE_FIELD, AUTH_TOKEN_STATUS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PendingModifiedValues.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer numCacheNodes;
    private final List<String> cacheNodeIdsToRemove;
    private final String engineVersion;
    private final String cacheNodeType;
    private final String authTokenStatus;
    private final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations;
    private final Boolean transitEncryptionEnabled;
    private final String transitEncryptionMode;

    private PendingModifiedValues(BuilderImpl builder) {
        this.numCacheNodes = builder.numCacheNodes;
        this.cacheNodeIdsToRemove = builder.cacheNodeIdsToRemove;
        this.engineVersion = builder.engineVersion;
        this.cacheNodeType = builder.cacheNodeType;
        this.authTokenStatus = builder.authTokenStatus;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.transitEncryptionMode = builder.transitEncryptionMode;
    }

    public final Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public final boolean hasCacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove != null && !(this.cacheNodeIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> cacheNodeIdsToRemove() {
        return this.cacheNodeIdsToRemove;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(this.authTokenStatus);
    }

    public final String authTokenStatusAsString() {
        return this.authTokenStatus;
    }

    public final boolean hasLogDeliveryConfigurations() {
        return this.logDeliveryConfigurations != null && !(this.logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations() {
        return this.logDeliveryConfigurations;
    }

    public final Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(this.transitEncryptionMode);
    }

    public final String transitEncryptionModeAsString() {
        return this.transitEncryptionMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheNodeIdsToRemove() ? this.cacheNodeIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedValues)) {
            return false;
        }
        PendingModifiedValues other = (PendingModifiedValues)obj;
        return Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && this.hasCacheNodeIdsToRemove() == other.hasCacheNodeIdsToRemove() && Objects.equals(this.cacheNodeIdsToRemove(), other.cacheNodeIdsToRemove()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.authTokenStatusAsString(), other.authTokenStatusAsString()) && this.hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations() && Objects.equals(this.logDeliveryConfigurations(), other.logDeliveryConfigurations()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.transitEncryptionModeAsString(), other.transitEncryptionModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PendingModifiedValues").add("NumCacheNodes", (Object)this.numCacheNodes()).add("CacheNodeIdsToRemove", this.hasCacheNodeIdsToRemove() ? this.cacheNodeIdsToRemove() : null).add("EngineVersion", (Object)this.engineVersion()).add("CacheNodeType", (Object)this.cacheNodeType()).add("AuthTokenStatus", (Object)this.authTokenStatusAsString()).add("LogDeliveryConfigurations", this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("TransitEncryptionMode", (Object)this.transitEncryptionModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "CacheNodeIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeIdsToRemove()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "AuthTokenStatus": {
                return Optional.ofNullable(clazz.cast(this.authTokenStatusAsString()));
            }
            case "LogDeliveryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfigurations()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "TransitEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NumCacheNodes", NUM_CACHE_NODES_FIELD);
        map.put("CacheNodeIdsToRemove", CACHE_NODE_IDS_TO_REMOVE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("CacheNodeType", CACHE_NODE_TYPE_FIELD);
        map.put("AuthTokenStatus", AUTH_TOKEN_STATUS_FIELD);
        map.put("LogDeliveryConfigurations", LOG_DELIVERY_CONFIGURATIONS_FIELD);
        map.put("TransitEncryptionEnabled", TRANSIT_ENCRYPTION_ENABLED_FIELD);
        map.put("TransitEncryptionMode", TRANSIT_ENCRYPTION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedValues, T> g) {
        return obj -> g.apply((PendingModifiedValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer numCacheNodes;
        private List<String> cacheNodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private String engineVersion;
        private String cacheNodeType;
        private String authTokenStatus;
        private List<PendingLogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean transitEncryptionEnabled;
        private String transitEncryptionMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedValues model) {
            this.numCacheNodes(model.numCacheNodes);
            this.cacheNodeIdsToRemove(model.cacheNodeIdsToRemove);
            this.engineVersion(model.engineVersion);
            this.cacheNodeType(model.cacheNodeType);
            this.authTokenStatus(model.authTokenStatus);
            this.logDeliveryConfigurations(model.logDeliveryConfigurations);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.transitEncryptionMode(model.transitEncryptionMode);
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final Collection<String> getCacheNodeIdsToRemove() {
            if (this.cacheNodeIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cacheNodeIdsToRemove;
        }

        public final void setCacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
        }

        @Override
        public final Builder cacheNodeIdsToRemove(Collection<String> cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove = CacheNodeIdsListCopier.copy(cacheNodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToRemove(String ... cacheNodeIdsToRemove) {
            this.cacheNodeIdsToRemove(Arrays.asList(cacheNodeIdsToRemove));
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getAuthTokenStatus() {
            return this.authTokenStatus;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final List<PendingLogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<PendingLogDeliveryConfiguration.Builder> result = PendingLogDeliveryConfigurationListCopier.copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder> ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Stream.of(logDeliveryConfigurations).map(c -> (PendingLogDeliveryConfiguration)((PendingLogDeliveryConfiguration.Builder)PendingLogDeliveryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final String getTransitEncryptionMode() {
            return this.transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public PendingModifiedValues build() {
            return new PendingModifiedValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingModifiedValues> {
        public Builder numCacheNodes(Integer var1);

        public Builder cacheNodeIdsToRemove(Collection<String> var1);

        public Builder cacheNodeIdsToRemove(String ... var1);

        public Builder engineVersion(String var1);

        public Builder cacheNodeType(String var1);

        public Builder authTokenStatus(String var1);

        public Builder authTokenStatus(AuthTokenUpdateStatus var1);

        public Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> var1);

        public Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration ... var1);

        public Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder> ... var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder transitEncryptionMode(String var1);

        public Builder transitEncryptionMode(TransitEncryptionMode var1);
    }
}

