/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdateStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceUpdatesRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, DescribeServiceUpdatesRequest> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUpdateName").getter(DescribeServiceUpdatesRequest.getter(DescribeServiceUpdatesRequest::serviceUpdateName)).setter(DescribeServiceUpdatesRequest.setter(Builder::serviceUpdateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()}).build();
    private static final SdkField<List<String>> SERVICE_UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceUpdateStatus").getter(DescribeServiceUpdatesRequest.getter(DescribeServiceUpdatesRequest::serviceUpdateStatusAsStrings)).setter(DescribeServiceUpdatesRequest.setter(Builder::serviceUpdateStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeServiceUpdatesRequest.getter(DescribeServiceUpdatesRequest::maxRecords)).setter(DescribeServiceUpdatesRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeServiceUpdatesRequest.getter(DescribeServiceUpdatesRequest::marker)).setter(DescribeServiceUpdatesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD, SERVICE_UPDATE_STATUS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceUpdatesRequest.memberNameToFieldInitializer();
    private final String serviceUpdateName;
    private final List<String> serviceUpdateStatus;
    private final Integer maxRecords;
    private final String marker;

    private DescribeServiceUpdatesRequest(BuilderImpl builder) {
        super(builder);
        this.serviceUpdateName = builder.serviceUpdateName;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final String serviceUpdateName() {
        return this.serviceUpdateName;
    }

    public final List<ServiceUpdateStatus> serviceUpdateStatus() {
        return ServiceUpdateStatusListCopier.copyStringToEnum(this.serviceUpdateStatus);
    }

    public final boolean hasServiceUpdateStatus() {
        return this.serviceUpdateStatus != null && !(this.serviceUpdateStatus instanceof SdkAutoConstructList);
    }

    public final List<String> serviceUpdateStatusAsStrings() {
        return this.serviceUpdateStatus;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceUpdateStatus() ? this.serviceUpdateStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceUpdatesRequest)) {
            return false;
        }
        DescribeServiceUpdatesRequest other = (DescribeServiceUpdatesRequest)((Object)obj);
        return Objects.equals(this.serviceUpdateName(), other.serviceUpdateName()) && this.hasServiceUpdateStatus() == other.hasServiceUpdateStatus() && Objects.equals(this.serviceUpdateStatusAsStrings(), other.serviceUpdateStatusAsStrings()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceUpdatesRequest").add("ServiceUpdateName", (Object)this.serviceUpdateName()).add("ServiceUpdateStatus", this.hasServiceUpdateStatus() ? this.serviceUpdateStatusAsStrings() : null).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceUpdateName": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateName()));
            }
            case "ServiceUpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.serviceUpdateStatusAsStrings()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
        map.put("ServiceUpdateStatus", SERVICE_UPDATE_STATUS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceUpdatesRequest, T> g) {
        return obj -> g.apply((DescribeServiceUpdatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String serviceUpdateName;
        private List<String> serviceUpdateStatus = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceUpdatesRequest model) {
            super(model);
            this.serviceUpdateName(model.serviceUpdateName);
            this.serviceUpdateStatusWithStrings(model.serviceUpdateStatus);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getServiceUpdateName() {
            return this.serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final Collection<String> getServiceUpdateStatus() {
            if (this.serviceUpdateStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceUpdateStatus;
        }

        public final void setServiceUpdateStatus(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
        }

        @Override
        public final Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatusWithStrings(String ... serviceUpdateStatus) {
            this.serviceUpdateStatusWithStrings(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copyEnumToString(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatus(ServiceUpdateStatus ... serviceUpdateStatus) {
            this.serviceUpdateStatus(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceUpdatesRequest build() {
            return new DescribeServiceUpdatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceUpdatesRequest> {
        public Builder serviceUpdateName(String var1);

        public Builder serviceUpdateStatusWithStrings(Collection<String> var1);

        public Builder serviceUpdateStatusWithStrings(String ... var1);

        public Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> var1);

        public Builder serviceUpdateStatus(ServiceUpdateStatus ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

