/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheUsageLimits;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.elasticache.model.SubnetIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessCache
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessCache> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerlessCacheName").getter(ServerlessCache.getter(ServerlessCache::serverlessCacheName)).setter(ServerlessCache.setter(Builder::serverlessCacheName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ServerlessCache.getter(ServerlessCache::description)).setter(ServerlessCache.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ServerlessCache.getter(ServerlessCache::createTime)).setter(ServerlessCache.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ServerlessCache.getter(ServerlessCache::status)).setter(ServerlessCache.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ServerlessCache.getter(ServerlessCache::engine)).setter(ServerlessCache.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(ServerlessCache.getter(ServerlessCache::majorEngineVersion)).setter(ServerlessCache.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<String> FULL_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FullEngineVersion").getter(ServerlessCache.getter(ServerlessCache::fullEngineVersion)).setter(ServerlessCache.setter(Builder::fullEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullEngineVersion").build()}).build();
    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheUsageLimits").getter(ServerlessCache.getter(ServerlessCache::cacheUsageLimits)).setter(ServerlessCache.setter(Builder::cacheUsageLimits)).constructor(CacheUsageLimits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ServerlessCache.getter(ServerlessCache::kmsKeyId)).setter(ServerlessCache.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ServerlessCache.getter(ServerlessCache::securityGroupIds)).setter(ServerlessCache.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(ServerlessCache.getter(ServerlessCache::endpoint)).setter(ServerlessCache.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Endpoint> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReaderEndpoint").getter(ServerlessCache.getter(ServerlessCache::readerEndpoint)).setter(ServerlessCache.setter(Builder::readerEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ServerlessCache.getter(ServerlessCache::arn)).setter(ServerlessCache.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroupId").getter(ServerlessCache.getter(ServerlessCache::userGroupId)).setter(ServerlessCache.setter(Builder::userGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(ServerlessCache.getter(ServerlessCache::subnetIds)).setter(ServerlessCache.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName("SubnetId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build()).build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(ServerlessCache.getter(ServerlessCache::snapshotRetentionLimit)).setter(ServerlessCache.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DailySnapshotTime").getter(ServerlessCache.getter(ServerlessCache::dailySnapshotTime)).setter(ServerlessCache.setter(Builder::dailySnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, STATUS_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD, FULL_ENGINE_VERSION_FIELD, CACHE_USAGE_LIMITS_FIELD, KMS_KEY_ID_FIELD, SECURITY_GROUP_IDS_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, ARN_FIELD, USER_GROUP_ID_FIELD, SUBNET_IDS_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, DAILY_SNAPSHOT_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerlessCache.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serverlessCacheName;
    private final String description;
    private final Instant createTime;
    private final String status;
    private final String engine;
    private final String majorEngineVersion;
    private final String fullEngineVersion;
    private final CacheUsageLimits cacheUsageLimits;
    private final String kmsKeyId;
    private final List<String> securityGroupIds;
    private final Endpoint endpoint;
    private final Endpoint readerEndpoint;
    private final String arn;
    private final String userGroupId;
    private final List<String> subnetIds;
    private final Integer snapshotRetentionLimit;
    private final String dailySnapshotTime;

    private ServerlessCache(BuilderImpl builder) {
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.fullEngineVersion = builder.fullEngineVersion;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.kmsKeyId = builder.kmsKeyId;
        this.securityGroupIds = builder.securityGroupIds;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.arn = builder.arn;
        this.userGroupId = builder.userGroupId;
        this.subnetIds = builder.subnetIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
    }

    public final String serverlessCacheName() {
        return this.serverlessCacheName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String status() {
        return this.status;
    }

    public final String engine() {
        return this.engine;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public final String fullEngineVersion() {
        return this.fullEngineVersion;
    }

    public final CacheUsageLimits cacheUsageLimits() {
        return this.cacheUsageLimits;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final Endpoint readerEndpoint() {
        return this.readerEndpoint;
    }

    public final String arn() {
        return this.arn;
    }

    public final String userGroupId() {
        return this.userGroupId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String dailySnapshotTime() {
        return this.dailySnapshotTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.dailySnapshotTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessCache)) {
            return false;
        }
        ServerlessCache other = (ServerlessCache)obj;
        return Objects.equals(this.serverlessCacheName(), other.serverlessCacheName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && Objects.equals(this.fullEngineVersion(), other.fullEngineVersion()) && Objects.equals(this.cacheUsageLimits(), other.cacheUsageLimits()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.userGroupId(), other.userGroupId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.dailySnapshotTime(), other.dailySnapshotTime());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessCache").add("ServerlessCacheName", (Object)this.serverlessCacheName()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("Status", (Object)this.status()).add("Engine", (Object)this.engine()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("FullEngineVersion", (Object)this.fullEngineVersion()).add("CacheUsageLimits", (Object)this.cacheUsageLimits()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("ARN", (Object)this.arn()).add("UserGroupId", (Object)this.userGroupId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("DailySnapshotTime", (Object)this.dailySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerlessCacheName": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "FullEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.fullEngineVersion()));
            }
            case "CacheUsageLimits": {
                return Optional.ofNullable(clazz.cast(this.cacheUsageLimits()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "UserGroupId": {
                return Optional.ofNullable(clazz.cast(this.userGroupId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "DailySnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.dailySnapshotTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerlessCacheName", SERVERLESS_CACHE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
        map.put("FullEngineVersion", FULL_ENGINE_VERSION_FIELD);
        map.put("CacheUsageLimits", CACHE_USAGE_LIMITS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("ReaderEndpoint", READER_ENDPOINT_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("UserGroupId", USER_GROUP_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
        map.put("DailySnapshotTime", DAILY_SNAPSHOT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessCache, T> g) {
        return obj -> g.apply((ServerlessCache)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverlessCacheName;
        private String description;
        private Instant createTime;
        private String status;
        private String engine;
        private String majorEngineVersion;
        private String fullEngineVersion;
        private CacheUsageLimits cacheUsageLimits;
        private String kmsKeyId;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Endpoint endpoint;
        private Endpoint readerEndpoint;
        private String arn;
        private String userGroupId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Integer snapshotRetentionLimit;
        private String dailySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessCache model) {
            this.serverlessCacheName(model.serverlessCacheName);
            this.description(model.description);
            this.createTime(model.createTime);
            this.status(model.status);
            this.engine(model.engine);
            this.majorEngineVersion(model.majorEngineVersion);
            this.fullEngineVersion(model.fullEngineVersion);
            this.cacheUsageLimits(model.cacheUsageLimits);
            this.kmsKeyId(model.kmsKeyId);
            this.securityGroupIds(model.securityGroupIds);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.arn(model.arn);
            this.userGroupId(model.userGroupId);
            this.subnetIds(model.subnetIds);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.dailySnapshotTime(model.dailySnapshotTime);
        }

        public final String getServerlessCacheName() {
            return this.serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getFullEngineVersion() {
            return this.fullEngineVersion;
        }

        public final void setFullEngineVersion(String fullEngineVersion) {
            this.fullEngineVersion = fullEngineVersion;
        }

        @Override
        public final Builder fullEngineVersion(String fullEngineVersion) {
            this.fullEngineVersion = fullEngineVersion;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return this.cacheUsageLimits != null ? this.cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Endpoint.Builder getReaderEndpoint() {
            return this.readerEndpoint != null ? this.readerEndpoint.toBuilder() : null;
        }

        public final void setReaderEndpoint(Endpoint.BuilderImpl readerEndpoint) {
            this.readerEndpoint = readerEndpoint != null ? readerEndpoint.build() : null;
        }

        @Override
        public final Builder readerEndpoint(Endpoint readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getUserGroupId() {
            return this.userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return this.dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        public ServerlessCache build() {
            return new ServerlessCache(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessCache> {
        public Builder serverlessCacheName(String var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder status(String var1);

        public Builder engine(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder fullEngineVersion(String var1);

        public Builder cacheUsageLimits(CacheUsageLimits var1);

        default public Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return this.cacheUsageLimits((CacheUsageLimits)((CacheUsageLimits.Builder)CacheUsageLimits.builder().applyMutation(cacheUsageLimits)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder readerEndpoint(Endpoint var1);

        default public Builder readerEndpoint(Consumer<Endpoint.Builder> readerEndpoint) {
            return this.readerEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(readerEndpoint)).build());
        }

        public Builder arn(String var1);

        public Builder userGroupId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder dailySnapshotTime(String var1);
    }
}

