/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeGroupMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeGroupMember> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(NodeGroupMember.getter(NodeGroupMember::cacheClusterId)).setter(NodeGroupMember.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeId").getter(NodeGroupMember.getter(NodeGroupMember::cacheNodeId)).setter(NodeGroupMember.setter(Builder::cacheNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()}).build();
    private static final SdkField<Endpoint> READ_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReadEndpoint").getter(NodeGroupMember.getter(NodeGroupMember::readEndpoint)).setter(NodeGroupMember.setter(Builder::readEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadEndpoint").build()}).build();
    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredAvailabilityZone").getter(NodeGroupMember.getter(NodeGroupMember::preferredAvailabilityZone)).setter(NodeGroupMember.setter(Builder::preferredAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build();
    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredOutpostArn").getter(NodeGroupMember.getter(NodeGroupMember::preferredOutpostArn)).setter(NodeGroupMember.setter(Builder::preferredOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build()}).build();
    private static final SdkField<String> CURRENT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentRole").getter(NodeGroupMember.getter(NodeGroupMember::currentRole)).setter(NodeGroupMember.setter(Builder::currentRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD, CACHE_NODE_ID_FIELD, READ_ENDPOINT_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_OUTPOST_ARN_FIELD, CURRENT_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CacheClusterId", CACHE_CLUSTER_ID_FIELD);
            this.put("CacheNodeId", CACHE_NODE_ID_FIELD);
            this.put("ReadEndpoint", READ_ENDPOINT_FIELD);
            this.put("PreferredAvailabilityZone", PREFERRED_AVAILABILITY_ZONE_FIELD);
            this.put("PreferredOutpostArn", PREFERRED_OUTPOST_ARN_FIELD);
            this.put("CurrentRole", CURRENT_ROLE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cacheClusterId;
    private final String cacheNodeId;
    private final Endpoint readEndpoint;
    private final String preferredAvailabilityZone;
    private final String preferredOutpostArn;
    private final String currentRole;

    private NodeGroupMember(BuilderImpl builder) {
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeId = builder.cacheNodeId;
        this.readEndpoint = builder.readEndpoint;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.currentRole = builder.currentRole;
    }

    public final String cacheClusterId() {
        return this.cacheClusterId;
    }

    public final String cacheNodeId() {
        return this.cacheNodeId;
    }

    public final Endpoint readEndpoint() {
        return this.readEndpoint;
    }

    public final String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public final String preferredOutpostArn() {
        return this.preferredOutpostArn;
    }

    public final String currentRole() {
        return this.currentRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.readEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupMember)) {
            return false;
        }
        NodeGroupMember other = (NodeGroupMember)obj;
        return Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.cacheNodeId(), other.cacheNodeId()) && Objects.equals(this.readEndpoint(), other.readEndpoint()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.preferredOutpostArn(), other.preferredOutpostArn()) && Objects.equals(this.currentRole(), other.currentRole());
    }

    public final String toString() {
        return ToString.builder((String)"NodeGroupMember").add("CacheClusterId", (Object)this.cacheClusterId()).add("CacheNodeId", (Object)this.cacheNodeId()).add("ReadEndpoint", (Object)this.readEndpoint()).add("PreferredAvailabilityZone", (Object)this.preferredAvailabilityZone()).add("PreferredOutpostArn", (Object)this.preferredOutpostArn()).add("CurrentRole", (Object)this.currentRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "CacheNodeId": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeId()));
            }
            case "ReadEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readEndpoint()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "PreferredOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.preferredOutpostArn()));
            }
            case "CurrentRole": {
                return Optional.ofNullable(clazz.cast(this.currentRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroupMember, T> g) {
        return obj -> g.apply((NodeGroupMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheClusterId;
        private String cacheNodeId;
        private Endpoint readEndpoint;
        private String preferredAvailabilityZone;
        private String preferredOutpostArn;
        private String currentRole;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroupMember model) {
            this.cacheClusterId(model.cacheClusterId);
            this.cacheNodeId(model.cacheNodeId);
            this.readEndpoint(model.readEndpoint);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.preferredOutpostArn(model.preferredOutpostArn);
            this.currentRole(model.currentRole);
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getCacheNodeId() {
            return this.cacheNodeId;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final Endpoint.Builder getReadEndpoint() {
            return this.readEndpoint != null ? this.readEndpoint.toBuilder() : null;
        }

        public final void setReadEndpoint(Endpoint.BuilderImpl readEndpoint) {
            this.readEndpoint = readEndpoint != null ? readEndpoint.build() : null;
        }

        @Override
        public final Builder readEndpoint(Endpoint readEndpoint) {
            this.readEndpoint = readEndpoint;
            return this;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final String getPreferredOutpostArn() {
            return this.preferredOutpostArn;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final String getCurrentRole() {
            return this.currentRole;
        }

        public final void setCurrentRole(String currentRole) {
            this.currentRole = currentRole;
        }

        @Override
        public final Builder currentRole(String currentRole) {
            this.currentRole = currentRole;
            return this;
        }

        public NodeGroupMember build() {
            return new NodeGroupMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeGroupMember> {
        public Builder cacheClusterId(String var1);

        public Builder cacheNodeId(String var1);

        public Builder readEndpoint(Endpoint var1);

        default public Builder readEndpoint(Consumer<Endpoint.Builder> readEndpoint) {
            return this.readEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(readEndpoint)).build());
        }

        public Builder preferredAvailabilityZone(String var1);

        public Builder preferredOutpostArn(String var1);

        public Builder currentRole(String var1);
    }
}

