/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.UserIdListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyUserGroupRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyUserGroupRequest> {
    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroupId").getter(ModifyUserGroupRequest.getter(ModifyUserGroupRequest::userGroupId)).setter(ModifyUserGroupRequest.setter(Builder::userGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()}).build();
    private static final SdkField<List<String>> USER_IDS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdsToAdd").getter(ModifyUserGroupRequest.getter(ModifyUserGroupRequest::userIdsToAdd)).setter(ModifyUserGroupRequest.setter(Builder::userIdsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdsToRemove").getter(ModifyUserGroupRequest.getter(ModifyUserGroupRequest::userIdsToRemove)).setter(ModifyUserGroupRequest.setter(Builder::userIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_GROUP_ID_FIELD, USER_IDS_TO_ADD_FIELD, USER_IDS_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserGroupId", USER_GROUP_ID_FIELD);
            this.put("UserIdsToAdd", USER_IDS_TO_ADD_FIELD);
            this.put("UserIdsToRemove", USER_IDS_TO_REMOVE_FIELD);
        }
    });
    private final String userGroupId;
    private final List<String> userIdsToAdd;
    private final List<String> userIdsToRemove;

    private ModifyUserGroupRequest(BuilderImpl builder) {
        super(builder);
        this.userGroupId = builder.userGroupId;
        this.userIdsToAdd = builder.userIdsToAdd;
        this.userIdsToRemove = builder.userIdsToRemove;
    }

    public final String userGroupId() {
        return this.userGroupId;
    }

    public final boolean hasUserIdsToAdd() {
        return this.userIdsToAdd != null && !(this.userIdsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> userIdsToAdd() {
        return this.userIdsToAdd;
    }

    public final boolean hasUserIdsToRemove() {
        return this.userIdsToRemove != null && !(this.userIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> userIdsToRemove() {
        return this.userIdsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdsToAdd() ? this.userIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdsToRemove() ? this.userIdsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUserGroupRequest)) {
            return false;
        }
        ModifyUserGroupRequest other = (ModifyUserGroupRequest)((Object)obj);
        return Objects.equals(this.userGroupId(), other.userGroupId()) && this.hasUserIdsToAdd() == other.hasUserIdsToAdd() && Objects.equals(this.userIdsToAdd(), other.userIdsToAdd()) && this.hasUserIdsToRemove() == other.hasUserIdsToRemove() && Objects.equals(this.userIdsToRemove(), other.userIdsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyUserGroupRequest").add("UserGroupId", (Object)this.userGroupId()).add("UserIdsToAdd", this.hasUserIdsToAdd() ? this.userIdsToAdd() : null).add("UserIdsToRemove", this.hasUserIdsToRemove() ? this.userIdsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserGroupId": {
                return Optional.ofNullable(clazz.cast(this.userGroupId()));
            }
            case "UserIdsToAdd": {
                return Optional.ofNullable(clazz.cast(this.userIdsToAdd()));
            }
            case "UserIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.userIdsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyUserGroupRequest, T> g) {
        return obj -> g.apply((ModifyUserGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String userGroupId;
        private List<String> userIdsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> userIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUserGroupRequest model) {
            super(model);
            this.userGroupId(model.userGroupId);
            this.userIdsToAdd(model.userIdsToAdd);
            this.userIdsToRemove(model.userIdsToRemove);
        }

        public final String getUserGroupId() {
            return this.userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getUserIdsToAdd() {
            if (this.userIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdsToAdd;
        }

        public final void setUserIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListInputCopier.copy(userIdsToAdd);
        }

        @Override
        public final Builder userIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListInputCopier.copy(userIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToAdd(String ... userIdsToAdd) {
            this.userIdsToAdd(Arrays.asList(userIdsToAdd));
            return this;
        }

        public final Collection<String> getUserIdsToRemove() {
            if (this.userIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdsToRemove;
        }

        public final void setUserIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListInputCopier.copy(userIdsToRemove);
        }

        @Override
        public final Builder userIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListInputCopier.copy(userIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToRemove(String ... userIdsToRemove) {
            this.userIdsToRemove(Arrays.asList(userIdsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUserGroupRequest build() {
            return new ModifyUserGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyUserGroupRequest> {
        public Builder userGroupId(String var1);

        public Builder userIdsToAdd(Collection<String> var1);

        public Builder userIdsToAdd(String ... var1);

        public Builder userIdsToRemove(Collection<String> var1);

        public Builder userIdsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

