/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.Endpoint;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMember;
import software.amazon.awssdk.services.elasticache.model.NodeGroupMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeGroup> {
    private static final SdkField<String> NODE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeGroupId").getter(NodeGroup.getter(NodeGroup::nodeGroupId)).setter(NodeGroup.setter(Builder::nodeGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NodeGroup.getter(NodeGroup::status)).setter(NodeGroup.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Endpoint> PRIMARY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryEndpoint").getter(NodeGroup.getter(NodeGroup::primaryEndpoint)).setter(NodeGroup.setter(Builder::primaryEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEndpoint").build()}).build();
    private static final SdkField<Endpoint> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReaderEndpoint").getter(NodeGroup.getter(NodeGroup::readerEndpoint)).setter(NodeGroup.setter(Builder::readerEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()}).build();
    private static final SdkField<String> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Slots").getter(NodeGroup.getter(NodeGroup::slots)).setter(NodeGroup.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build()}).build();
    private static final SdkField<List<NodeGroupMember>> NODE_GROUP_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroupMembers").getter(NodeGroup.getter(NodeGroup::nodeGroupMembers)).setter(NodeGroup.setter(Builder::nodeGroupMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupMembers").build(), ListTrait.builder().memberLocationName("NodeGroupMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeGroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupMember").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_GROUP_ID_FIELD, STATUS_FIELD, PRIMARY_ENDPOINT_FIELD, READER_ENDPOINT_FIELD, SLOTS_FIELD, NODE_GROUP_MEMBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeGroupId;
    private final String status;
    private final Endpoint primaryEndpoint;
    private final Endpoint readerEndpoint;
    private final String slots;
    private final List<NodeGroupMember> nodeGroupMembers;

    private NodeGroup(BuilderImpl builder) {
        this.nodeGroupId = builder.nodeGroupId;
        this.status = builder.status;
        this.primaryEndpoint = builder.primaryEndpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.slots = builder.slots;
        this.nodeGroupMembers = builder.nodeGroupMembers;
    }

    public final String nodeGroupId() {
        return this.nodeGroupId;
    }

    public final String status() {
        return this.status;
    }

    public final Endpoint primaryEndpoint() {
        return this.primaryEndpoint;
    }

    public final Endpoint readerEndpoint() {
        return this.readerEndpoint;
    }

    public final String slots() {
        return this.slots;
    }

    public final boolean hasNodeGroupMembers() {
        return this.nodeGroupMembers != null && !(this.nodeGroupMembers instanceof SdkAutoConstructList);
    }

    public final List<NodeGroupMember> nodeGroupMembers() {
        return this.nodeGroupMembers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.slots());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeGroupMembers() ? this.nodeGroupMembers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroup)) {
            return false;
        }
        NodeGroup other = (NodeGroup)obj;
        return Objects.equals(this.nodeGroupId(), other.nodeGroupId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.primaryEndpoint(), other.primaryEndpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && Objects.equals(this.slots(), other.slots()) && this.hasNodeGroupMembers() == other.hasNodeGroupMembers() && Objects.equals(this.nodeGroupMembers(), other.nodeGroupMembers());
    }

    public final String toString() {
        return ToString.builder((String)"NodeGroup").add("NodeGroupId", (Object)this.nodeGroupId()).add("Status", (Object)this.status()).add("PrimaryEndpoint", (Object)this.primaryEndpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("Slots", (Object)this.slots()).add("NodeGroupMembers", this.hasNodeGroupMembers() ? this.nodeGroupMembers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeGroupId": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PrimaryEndpoint": {
                return Optional.ofNullable(clazz.cast(this.primaryEndpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "Slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "NodeGroupMembers": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupMembers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeGroup, T> g) {
        return obj -> g.apply((NodeGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeGroupId;
        private String status;
        private Endpoint primaryEndpoint;
        private Endpoint readerEndpoint;
        private String slots;
        private List<NodeGroupMember> nodeGroupMembers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeGroup model) {
            this.nodeGroupId(model.nodeGroupId);
            this.status(model.status);
            this.primaryEndpoint(model.primaryEndpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.slots(model.slots);
            this.nodeGroupMembers(model.nodeGroupMembers);
        }

        public final String getNodeGroupId() {
            return this.nodeGroupId;
        }

        public final void setNodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
        }

        @Override
        public final Builder nodeGroupId(String nodeGroupId) {
            this.nodeGroupId = nodeGroupId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Endpoint.Builder getPrimaryEndpoint() {
            return this.primaryEndpoint != null ? this.primaryEndpoint.toBuilder() : null;
        }

        public final void setPrimaryEndpoint(Endpoint.BuilderImpl primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint != null ? primaryEndpoint.build() : null;
        }

        @Override
        public final Builder primaryEndpoint(Endpoint primaryEndpoint) {
            this.primaryEndpoint = primaryEndpoint;
            return this;
        }

        public final Endpoint.Builder getReaderEndpoint() {
            return this.readerEndpoint != null ? this.readerEndpoint.toBuilder() : null;
        }

        public final void setReaderEndpoint(Endpoint.BuilderImpl readerEndpoint) {
            this.readerEndpoint = readerEndpoint != null ? readerEndpoint.build() : null;
        }

        @Override
        public final Builder readerEndpoint(Endpoint readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final String getSlots() {
            return this.slots;
        }

        public final void setSlots(String slots) {
            this.slots = slots;
        }

        @Override
        public final Builder slots(String slots) {
            this.slots = slots;
            return this;
        }

        public final List<NodeGroupMember.Builder> getNodeGroupMembers() {
            List<NodeGroupMember.Builder> result = NodeGroupMemberListCopier.copyToBuilder(this.nodeGroupMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeGroupMembers(Collection<NodeGroupMember.BuilderImpl> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copyFromBuilder(nodeGroupMembers);
        }

        @Override
        public final Builder nodeGroupMembers(Collection<NodeGroupMember> nodeGroupMembers) {
            this.nodeGroupMembers = NodeGroupMemberListCopier.copy(nodeGroupMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMembers(NodeGroupMember ... nodeGroupMembers) {
            this.nodeGroupMembers(Arrays.asList(nodeGroupMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeGroupMembers(Consumer<NodeGroupMember.Builder> ... nodeGroupMembers) {
            this.nodeGroupMembers(Stream.of(nodeGroupMembers).map(c -> (NodeGroupMember)((NodeGroupMember.Builder)NodeGroupMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeGroup build() {
            return new NodeGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeGroup> {
        public Builder nodeGroupId(String var1);

        public Builder status(String var1);

        public Builder primaryEndpoint(Endpoint var1);

        default public Builder primaryEndpoint(Consumer<Endpoint.Builder> primaryEndpoint) {
            return this.primaryEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(primaryEndpoint)).build());
        }

        public Builder readerEndpoint(Endpoint var1);

        default public Builder readerEndpoint(Consumer<Endpoint.Builder> readerEndpoint) {
            return this.readerEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(readerEndpoint)).build());
        }

        public Builder slots(String var1);

        public Builder nodeGroupMembers(Collection<NodeGroupMember> var1);

        public Builder nodeGroupMembers(NodeGroupMember ... var1);

        public Builder nodeGroupMembers(Consumer<NodeGroupMember.Builder> ... var1);
    }
}

