/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshot;
import software.amazon.awssdk.services.elasticache.model.ServerlessCacheSnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServerlessCacheSnapshotsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeServerlessCacheSnapshotsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeServerlessCacheSnapshotsResponse.getter(DescribeServerlessCacheSnapshotsResponse::nextToken)).setter(DescribeServerlessCacheSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServerlessCacheSnapshot>> SERVERLESS_CACHE_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServerlessCacheSnapshots").getter(DescribeServerlessCacheSnapshotsResponse.getter(DescribeServerlessCacheSnapshotsResponse::serverlessCacheSnapshots)).setter(DescribeServerlessCacheSnapshotsResponse.setter(Builder::serverlessCacheSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshots").build(), ListTrait.builder().memberLocationName("ServerlessCacheSnapshot").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerlessCacheSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshot").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVERLESS_CACHE_SNAPSHOTS_FIELD));
    private final String nextToken;
    private final List<ServerlessCacheSnapshot> serverlessCacheSnapshots;

    private DescribeServerlessCacheSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverlessCacheSnapshots = builder.serverlessCacheSnapshots;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServerlessCacheSnapshots() {
        return this.serverlessCacheSnapshots != null && !(this.serverlessCacheSnapshots instanceof SdkAutoConstructList);
    }

    public final List<ServerlessCacheSnapshot> serverlessCacheSnapshots() {
        return this.serverlessCacheSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerlessCacheSnapshots() ? this.serverlessCacheSnapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCacheSnapshotsResponse)) {
            return false;
        }
        DescribeServerlessCacheSnapshotsResponse other = (DescribeServerlessCacheSnapshotsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServerlessCacheSnapshots() == other.hasServerlessCacheSnapshots() && Objects.equals(this.serverlessCacheSnapshots(), other.serverlessCacheSnapshots());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServerlessCacheSnapshotsResponse").add("NextToken", (Object)this.nextToken()).add("ServerlessCacheSnapshots", this.hasServerlessCacheSnapshots() ? this.serverlessCacheSnapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServerlessCacheSnapshots": {
                return Optional.ofNullable(clazz.cast(this.serverlessCacheSnapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCacheSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeServerlessCacheSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServerlessCacheSnapshot> serverlessCacheSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCacheSnapshotsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serverlessCacheSnapshots(model.serverlessCacheSnapshots);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServerlessCacheSnapshot.Builder> getServerlessCacheSnapshots() {
            List<ServerlessCacheSnapshot.Builder> result = ServerlessCacheSnapshotListCopier.copyToBuilder(this.serverlessCacheSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerlessCacheSnapshots(Collection<ServerlessCacheSnapshot.BuilderImpl> serverlessCacheSnapshots) {
            this.serverlessCacheSnapshots = ServerlessCacheSnapshotListCopier.copyFromBuilder(serverlessCacheSnapshots);
        }

        @Override
        public final Builder serverlessCacheSnapshots(Collection<ServerlessCacheSnapshot> serverlessCacheSnapshots) {
            this.serverlessCacheSnapshots = ServerlessCacheSnapshotListCopier.copy(serverlessCacheSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCacheSnapshots(ServerlessCacheSnapshot ... serverlessCacheSnapshots) {
            this.serverlessCacheSnapshots(Arrays.asList(serverlessCacheSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCacheSnapshots(Consumer<ServerlessCacheSnapshot.Builder> ... serverlessCacheSnapshots) {
            this.serverlessCacheSnapshots(Stream.of(serverlessCacheSnapshots).map(c -> (ServerlessCacheSnapshot)((ServerlessCacheSnapshot.Builder)ServerlessCacheSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServerlessCacheSnapshotsResponse build() {
            return new DescribeServerlessCacheSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServerlessCacheSnapshotsResponse> {
        public Builder nextToken(String var1);

        public Builder serverlessCacheSnapshots(Collection<ServerlessCacheSnapshot> var1);

        public Builder serverlessCacheSnapshots(ServerlessCacheSnapshot ... var1);

        public Builder serverlessCacheSnapshots(Consumer<ServerlessCacheSnapshot.Builder> ... var1);
    }
}

