/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.DataTieringStatus;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshot;
import software.amazon.awssdk.services.elasticache.model.NodeSnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Snapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Snapshot> {
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotName").getter(Snapshot.getter(Snapshot::snapshotName)).setter(Snapshot.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(Snapshot.getter(Snapshot::replicationGroupId)).setter(Snapshot.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<String> REPLICATION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupDescription").getter(Snapshot.getter(Snapshot::replicationGroupDescription)).setter(Snapshot.setter(Builder::replicationGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupDescription").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterId").getter(Snapshot.getter(Snapshot::cacheClusterId)).setter(Snapshot.setter(Builder::cacheClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()}).build();
    private static final SdkField<String> SNAPSHOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotStatus").getter(Snapshot.getter(Snapshot::snapshotStatus)).setter(Snapshot.setter(Builder::snapshotStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotStatus").build()}).build();
    private static final SdkField<String> SNAPSHOT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotSource").getter(Snapshot.getter(Snapshot::snapshotSource)).setter(Snapshot.setter(Builder::snapshotSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSource").build()}).build();
    private static final SdkField<String> CACHE_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheNodeType").getter(Snapshot.getter(Snapshot::cacheNodeType)).setter(Snapshot.setter(Builder::cacheNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(Snapshot.getter(Snapshot::engine)).setter(Snapshot.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(Snapshot.getter(Snapshot::engineVersion)).setter(Snapshot.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> NUM_CACHE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumCacheNodes").getter(Snapshot.getter(Snapshot::numCacheNodes)).setter(Snapshot.setter(Builder::numCacheNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumCacheNodes").build()}).build();
    private static final SdkField<String> PREFERRED_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredAvailabilityZone").getter(Snapshot.getter(Snapshot::preferredAvailabilityZone)).setter(Snapshot.setter(Builder::preferredAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredAvailabilityZone").build()}).build();
    private static final SdkField<String> PREFERRED_OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredOutpostArn").getter(Snapshot.getter(Snapshot::preferredOutpostArn)).setter(Snapshot.setter(Builder::preferredOutpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredOutpostArn").build()}).build();
    private static final SdkField<Instant> CACHE_CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CacheClusterCreateTime").getter(Snapshot.getter(Snapshot::cacheClusterCreateTime)).setter(Snapshot.setter(Builder::cacheClusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterCreateTime").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(Snapshot.getter(Snapshot::preferredMaintenanceWindow)).setter(Snapshot.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(Snapshot.getter(Snapshot::topicArn)).setter(Snapshot.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(Snapshot.getter(Snapshot::port)).setter(Snapshot.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> CACHE_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheParameterGroupName").getter(Snapshot.getter(Snapshot::cacheParameterGroupName)).setter(Snapshot.setter(Builder::cacheParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheParameterGroupName").build()}).build();
    private static final SdkField<String> CACHE_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSubnetGroupName").getter(Snapshot.getter(Snapshot::cacheSubnetGroupName)).setter(Snapshot.setter(Builder::cacheSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSubnetGroupName").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Snapshot.getter(Snapshot::vpcId)).setter(Snapshot.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(Snapshot.getter(Snapshot::autoMinorVersionUpgrade)).setter(Snapshot.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(Snapshot.getter(Snapshot::snapshotRetentionLimit)).setter(Snapshot.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(Snapshot.getter(Snapshot::snapshotWindow)).setter(Snapshot.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<Integer> NUM_NODE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumNodeGroups").getter(Snapshot.getter(Snapshot::numNodeGroups)).setter(Snapshot.setter(Builder::numNodeGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumNodeGroups").build()}).build();
    private static final SdkField<String> AUTOMATIC_FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomaticFailover").getter(Snapshot.getter(Snapshot::automaticFailoverAsString)).setter(Snapshot.setter(Builder::automaticFailover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailover").build()}).build();
    private static final SdkField<List<NodeSnapshot>> NODE_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeSnapshots").getter(Snapshot.getter(Snapshot::nodeSnapshots)).setter(Snapshot.setter(Builder::nodeSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeSnapshots").build(), ListTrait.builder().memberLocationName("NodeSnapshot").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeSnapshot").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(Snapshot.getter(Snapshot::kmsKeyId)).setter(Snapshot.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(Snapshot.getter(Snapshot::arn)).setter(Snapshot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTiering").getter(Snapshot.getter(Snapshot::dataTieringAsString)).setter(Snapshot.setter(Builder::dataTiering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_NAME_FIELD, REPLICATION_GROUP_ID_FIELD, REPLICATION_GROUP_DESCRIPTION_FIELD, CACHE_CLUSTER_ID_FIELD, SNAPSHOT_STATUS_FIELD, SNAPSHOT_SOURCE_FIELD, CACHE_NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, NUM_CACHE_NODES_FIELD, PREFERRED_AVAILABILITY_ZONE_FIELD, PREFERRED_OUTPOST_ARN_FIELD, CACHE_CLUSTER_CREATE_TIME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, TOPIC_ARN_FIELD, PORT_FIELD, CACHE_PARAMETER_GROUP_NAME_FIELD, CACHE_SUBNET_GROUP_NAME_FIELD, VPC_ID_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, SNAPSHOT_WINDOW_FIELD, NUM_NODE_GROUPS_FIELD, AUTOMATIC_FAILOVER_FIELD, NODE_SNAPSHOTS_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD, DATA_TIERING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotName;
    private final String replicationGroupId;
    private final String replicationGroupDescription;
    private final String cacheClusterId;
    private final String snapshotStatus;
    private final String snapshotSource;
    private final String cacheNodeType;
    private final String engine;
    private final String engineVersion;
    private final Integer numCacheNodes;
    private final String preferredAvailabilityZone;
    private final String preferredOutpostArn;
    private final Instant cacheClusterCreateTime;
    private final String preferredMaintenanceWindow;
    private final String topicArn;
    private final Integer port;
    private final String cacheParameterGroupName;
    private final String cacheSubnetGroupName;
    private final String vpcId;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer snapshotRetentionLimit;
    private final String snapshotWindow;
    private final Integer numNodeGroups;
    private final String automaticFailover;
    private final List<NodeSnapshot> nodeSnapshots;
    private final String kmsKeyId;
    private final String arn;
    private final String dataTiering;

    private Snapshot(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.replicationGroupId = builder.replicationGroupId;
        this.replicationGroupDescription = builder.replicationGroupDescription;
        this.cacheClusterId = builder.cacheClusterId;
        this.snapshotStatus = builder.snapshotStatus;
        this.snapshotSource = builder.snapshotSource;
        this.cacheNodeType = builder.cacheNodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.numCacheNodes = builder.numCacheNodes;
        this.preferredAvailabilityZone = builder.preferredAvailabilityZone;
        this.preferredOutpostArn = builder.preferredOutpostArn;
        this.cacheClusterCreateTime = builder.cacheClusterCreateTime;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.topicArn = builder.topicArn;
        this.port = builder.port;
        this.cacheParameterGroupName = builder.cacheParameterGroupName;
        this.cacheSubnetGroupName = builder.cacheSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.snapshotWindow = builder.snapshotWindow;
        this.numNodeGroups = builder.numNodeGroups;
        this.automaticFailover = builder.automaticFailover;
        this.nodeSnapshots = builder.nodeSnapshots;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.dataTiering = builder.dataTiering;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final String replicationGroupDescription() {
        return this.replicationGroupDescription;
    }

    public final String cacheClusterId() {
        return this.cacheClusterId;
    }

    public final String snapshotStatus() {
        return this.snapshotStatus;
    }

    public final String snapshotSource() {
        return this.snapshotSource;
    }

    public final String cacheNodeType() {
        return this.cacheNodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer numCacheNodes() {
        return this.numCacheNodes;
    }

    public final String preferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public final String preferredOutpostArn() {
        return this.preferredOutpostArn;
    }

    public final Instant cacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final Integer port() {
        return this.port;
    }

    public final String cacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public final String cacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final Integer numNodeGroups() {
        return this.numNodeGroups;
    }

    public final AutomaticFailoverStatus automaticFailover() {
        return AutomaticFailoverStatus.fromValue(this.automaticFailover);
    }

    public final String automaticFailoverAsString() {
        return this.automaticFailover;
    }

    public final boolean hasNodeSnapshots() {
        return this.nodeSnapshots != null && !(this.nodeSnapshots instanceof SdkAutoConstructList);
    }

    public final List<NodeSnapshot> nodeSnapshots() {
        return this.nodeSnapshots;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String arn() {
        return this.arn;
    }

    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(this.dataTiering);
    }

    public final String dataTieringAsString() {
        return this.dataTiering;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.numCacheNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredOutpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.numNodeGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeSnapshots() ? this.nodeSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTieringAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.replicationGroupDescription(), other.replicationGroupDescription()) && Objects.equals(this.cacheClusterId(), other.cacheClusterId()) && Objects.equals(this.snapshotStatus(), other.snapshotStatus()) && Objects.equals(this.snapshotSource(), other.snapshotSource()) && Objects.equals(this.cacheNodeType(), other.cacheNodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.numCacheNodes(), other.numCacheNodes()) && Objects.equals(this.preferredAvailabilityZone(), other.preferredAvailabilityZone()) && Objects.equals(this.preferredOutpostArn(), other.preferredOutpostArn()) && Objects.equals(this.cacheClusterCreateTime(), other.cacheClusterCreateTime()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.cacheParameterGroupName(), other.cacheParameterGroupName()) && Objects.equals(this.cacheSubnetGroupName(), other.cacheSubnetGroupName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.numNodeGroups(), other.numNodeGroups()) && Objects.equals(this.automaticFailoverAsString(), other.automaticFailoverAsString()) && this.hasNodeSnapshots() == other.hasNodeSnapshots() && Objects.equals(this.nodeSnapshots(), other.nodeSnapshots()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataTieringAsString(), other.dataTieringAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Snapshot").add("SnapshotName", (Object)this.snapshotName()).add("ReplicationGroupId", (Object)this.replicationGroupId()).add("ReplicationGroupDescription", (Object)this.replicationGroupDescription()).add("CacheClusterId", (Object)this.cacheClusterId()).add("SnapshotStatus", (Object)this.snapshotStatus()).add("SnapshotSource", (Object)this.snapshotSource()).add("CacheNodeType", (Object)this.cacheNodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("NumCacheNodes", (Object)this.numCacheNodes()).add("PreferredAvailabilityZone", (Object)this.preferredAvailabilityZone()).add("PreferredOutpostArn", (Object)this.preferredOutpostArn()).add("CacheClusterCreateTime", (Object)this.cacheClusterCreateTime()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("TopicArn", (Object)this.topicArn()).add("Port", (Object)this.port()).add("CacheParameterGroupName", (Object)this.cacheParameterGroupName()).add("CacheSubnetGroupName", (Object)this.cacheSubnetGroupName()).add("VpcId", (Object)this.vpcId()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("NumNodeGroups", (Object)this.numNodeGroups()).add("AutomaticFailover", (Object)this.automaticFailoverAsString()).add("NodeSnapshots", this.hasNodeSnapshots() ? this.nodeSnapshots() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("ARN", (Object)this.arn()).add("DataTiering", (Object)this.dataTieringAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "ReplicationGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupDescription()));
            }
            case "CacheClusterId": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterId()));
            }
            case "SnapshotStatus": {
                return Optional.ofNullable(clazz.cast(this.snapshotStatus()));
            }
            case "SnapshotSource": {
                return Optional.ofNullable(clazz.cast(this.snapshotSource()));
            }
            case "CacheNodeType": {
                return Optional.ofNullable(clazz.cast(this.cacheNodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "NumCacheNodes": {
                return Optional.ofNullable(clazz.cast(this.numCacheNodes()));
            }
            case "PreferredAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.preferredAvailabilityZone()));
            }
            case "PreferredOutpostArn": {
                return Optional.ofNullable(clazz.cast(this.preferredOutpostArn()));
            }
            case "CacheClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterCreateTime()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "CacheParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheParameterGroupName()));
            }
            case "CacheSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSubnetGroupName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "NumNodeGroups": {
                return Optional.ofNullable(clazz.cast(this.numNodeGroups()));
            }
            case "AutomaticFailover": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverAsString()));
            }
            case "NodeSnapshots": {
                return Optional.ofNullable(clazz.cast(this.nodeSnapshots()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DataTiering": {
                return Optional.ofNullable(clazz.cast(this.dataTieringAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotName;
        private String replicationGroupId;
        private String replicationGroupDescription;
        private String cacheClusterId;
        private String snapshotStatus;
        private String snapshotSource;
        private String cacheNodeType;
        private String engine;
        private String engineVersion;
        private Integer numCacheNodes;
        private String preferredAvailabilityZone;
        private String preferredOutpostArn;
        private Instant cacheClusterCreateTime;
        private String preferredMaintenanceWindow;
        private String topicArn;
        private Integer port;
        private String cacheParameterGroupName;
        private String cacheSubnetGroupName;
        private String vpcId;
        private Boolean autoMinorVersionUpgrade;
        private Integer snapshotRetentionLimit;
        private String snapshotWindow;
        private Integer numNodeGroups;
        private String automaticFailover;
        private List<NodeSnapshot> nodeSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private String arn;
        private String dataTiering;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.snapshotName(model.snapshotName);
            this.replicationGroupId(model.replicationGroupId);
            this.replicationGroupDescription(model.replicationGroupDescription);
            this.cacheClusterId(model.cacheClusterId);
            this.snapshotStatus(model.snapshotStatus);
            this.snapshotSource(model.snapshotSource);
            this.cacheNodeType(model.cacheNodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.numCacheNodes(model.numCacheNodes);
            this.preferredAvailabilityZone(model.preferredAvailabilityZone);
            this.preferredOutpostArn(model.preferredOutpostArn);
            this.cacheClusterCreateTime(model.cacheClusterCreateTime);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.topicArn(model.topicArn);
            this.port(model.port);
            this.cacheParameterGroupName(model.cacheParameterGroupName);
            this.cacheSubnetGroupName(model.cacheSubnetGroupName);
            this.vpcId(model.vpcId);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.snapshotWindow(model.snapshotWindow);
            this.numNodeGroups(model.numNodeGroups);
            this.automaticFailover(model.automaticFailover);
            this.nodeSnapshots(model.nodeSnapshots);
            this.kmsKeyId(model.kmsKeyId);
            this.arn(model.arn);
            this.dataTiering(model.dataTiering);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final String getReplicationGroupDescription() {
            return this.replicationGroupDescription;
        }

        public final void setReplicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
        }

        @Override
        public final Builder replicationGroupDescription(String replicationGroupDescription) {
            this.replicationGroupDescription = replicationGroupDescription;
            return this;
        }

        public final String getCacheClusterId() {
            return this.cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final String getSnapshotStatus() {
            return this.snapshotStatus;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        @Override
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        public final String getSnapshotSource() {
            return this.snapshotSource;
        }

        public final void setSnapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
        }

        @Override
        public final Builder snapshotSource(String snapshotSource) {
            this.snapshotSource = snapshotSource;
            return this;
        }

        public final String getCacheNodeType() {
            return this.cacheNodeType;
        }

        public final void setCacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
        }

        @Override
        public final Builder cacheNodeType(String cacheNodeType) {
            this.cacheNodeType = cacheNodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getNumCacheNodes() {
            return this.numCacheNodes;
        }

        public final void setNumCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
        }

        @Override
        public final Builder numCacheNodes(Integer numCacheNodes) {
            this.numCacheNodes = numCacheNodes;
            return this;
        }

        public final String getPreferredAvailabilityZone() {
            return this.preferredAvailabilityZone;
        }

        public final void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
        }

        @Override
        public final Builder preferredAvailabilityZone(String preferredAvailabilityZone) {
            this.preferredAvailabilityZone = preferredAvailabilityZone;
            return this;
        }

        public final String getPreferredOutpostArn() {
            return this.preferredOutpostArn;
        }

        public final void setPreferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
        }

        @Override
        public final Builder preferredOutpostArn(String preferredOutpostArn) {
            this.preferredOutpostArn = preferredOutpostArn;
            return this;
        }

        public final Instant getCacheClusterCreateTime() {
            return this.cacheClusterCreateTime;
        }

        public final void setCacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
        }

        @Override
        public final Builder cacheClusterCreateTime(Instant cacheClusterCreateTime) {
            this.cacheClusterCreateTime = cacheClusterCreateTime;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getCacheParameterGroupName() {
            return this.cacheParameterGroupName;
        }

        public final void setCacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
        }

        @Override
        public final Builder cacheParameterGroupName(String cacheParameterGroupName) {
            this.cacheParameterGroupName = cacheParameterGroupName;
            return this;
        }

        public final String getCacheSubnetGroupName() {
            return this.cacheSubnetGroupName;
        }

        public final void setCacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
        }

        @Override
        public final Builder cacheSubnetGroupName(String cacheSubnetGroupName) {
            this.cacheSubnetGroupName = cacheSubnetGroupName;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Integer getNumNodeGroups() {
            return this.numNodeGroups;
        }

        public final void setNumNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
        }

        @Override
        public final Builder numNodeGroups(Integer numNodeGroups) {
            this.numNodeGroups = numNodeGroups;
            return this;
        }

        public final String getAutomaticFailover() {
            return this.automaticFailover;
        }

        public final void setAutomaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
        }

        @Override
        public final Builder automaticFailover(String automaticFailover) {
            this.automaticFailover = automaticFailover;
            return this;
        }

        @Override
        public final Builder automaticFailover(AutomaticFailoverStatus automaticFailover) {
            this.automaticFailover(automaticFailover == null ? null : automaticFailover.toString());
            return this;
        }

        public final List<NodeSnapshot.Builder> getNodeSnapshots() {
            List<NodeSnapshot.Builder> result = NodeSnapshotListCopier.copyToBuilder(this.nodeSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeSnapshots(Collection<NodeSnapshot.BuilderImpl> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copyFromBuilder(nodeSnapshots);
        }

        @Override
        public final Builder nodeSnapshots(Collection<NodeSnapshot> nodeSnapshots) {
            this.nodeSnapshots = NodeSnapshotListCopier.copy(nodeSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSnapshots(NodeSnapshot ... nodeSnapshots) {
            this.nodeSnapshots(Arrays.asList(nodeSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeSnapshots(Consumer<NodeSnapshot.Builder> ... nodeSnapshots) {
            this.nodeSnapshots(Stream.of(nodeSnapshots).map(c -> (NodeSnapshot)((NodeSnapshot.Builder)NodeSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataTiering() {
            return this.dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Snapshot> {
        public Builder snapshotName(String var1);

        public Builder replicationGroupId(String var1);

        public Builder replicationGroupDescription(String var1);

        public Builder cacheClusterId(String var1);

        public Builder snapshotStatus(String var1);

        public Builder snapshotSource(String var1);

        public Builder cacheNodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder numCacheNodes(Integer var1);

        public Builder preferredAvailabilityZone(String var1);

        public Builder preferredOutpostArn(String var1);

        public Builder cacheClusterCreateTime(Instant var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder topicArn(String var1);

        public Builder port(Integer var1);

        public Builder cacheParameterGroupName(String var1);

        public Builder cacheSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder snapshotWindow(String var1);

        public Builder numNodeGroups(Integer var1);

        public Builder automaticFailover(String var1);

        public Builder automaticFailover(AutomaticFailoverStatus var1);

        public Builder nodeSnapshots(Collection<NodeSnapshot> var1);

        public Builder nodeSnapshots(NodeSnapshot ... var1);

        public Builder nodeSnapshots(Consumer<NodeSnapshot.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder arn(String var1);

        public Builder dataTiering(String var1);

        public Builder dataTiering(DataTieringStatus var1);
    }
}

