/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheBaseClientBuilder;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClient;
import software.amazon.awssdk.services.elasticache.ElastiCacheAsyncClientBuilder;
import software.amazon.awssdk.services.elasticache.ElastiCacheServiceClientConfiguration;
import software.amazon.awssdk.services.elasticache.endpoints.ElastiCacheEndpointProvider;

@SdkInternalApi
final class DefaultElastiCacheAsyncClientBuilder
extends DefaultElastiCacheBaseClientBuilder<ElastiCacheAsyncClientBuilder, ElastiCacheAsyncClient>
implements ElastiCacheAsyncClientBuilder {
    DefaultElastiCacheAsyncClientBuilder() {
    }

    @Override
    public DefaultElastiCacheAsyncClientBuilder endpointProvider(ElastiCacheEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElastiCacheAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElastiCacheAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElastiCacheServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElastiCacheAsyncClient client = new DefaultElastiCacheAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElastiCacheServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElastiCacheServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

