/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheBaseClientBuilder;
import software.amazon.awssdk.services.elasticache.DefaultElastiCacheClient;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.ElastiCacheClientBuilder;
import software.amazon.awssdk.services.elasticache.ElastiCacheServiceClientConfiguration;
import software.amazon.awssdk.services.elasticache.endpoints.ElastiCacheEndpointProvider;

@SdkInternalApi
final class DefaultElastiCacheClientBuilder
extends DefaultElastiCacheBaseClientBuilder<ElastiCacheClientBuilder, ElastiCacheClient>
implements ElastiCacheClientBuilder {
    DefaultElastiCacheClientBuilder() {
    }

    @Override
    public DefaultElastiCacheClientBuilder endpointProvider(ElastiCacheEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElastiCacheClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultElastiCacheClientBuilder.validateClientOptions(clientConfiguration);
        ElastiCacheServiceClientConfiguration serviceClientConfiguration = ElastiCacheServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultElastiCacheClient(serviceClientConfiguration, clientConfiguration);
    }
}

