/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeUserGroupsResponse;
import software.amazon.awssdk.services.elasticache.model.UserGroup;

public class DescribeUserGroupsIterable
implements SdkIterable<DescribeUserGroupsResponse> {
    private final ElastiCacheClient client;
    private final DescribeUserGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeUserGroupsIterable(ElastiCacheClient client, DescribeUserGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeUserGroupsResponseFetcher();
    }

    public Iterator<DescribeUserGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UserGroup> userGroups() {
        Function<DescribeUserGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userGroups() != null) {
                return response.userGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeUserGroupsResponseFetcher
    implements SyncPageFetcher<DescribeUserGroupsResponse> {
        private DescribeUserGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUserGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeUserGroupsResponse nextPage(DescribeUserGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUserGroupsIterable.this.client.describeUserGroups(DescribeUserGroupsIterable.this.firstRequest);
            }
            return DescribeUserGroupsIterable.this.client.describeUserGroups((DescribeUserGroupsRequest)((Object)DescribeUserGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

