/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AZMode {
    SINGLE_AZ("single-az"),
    CROSS_AZ("cross-az"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AZMode> VALUE_MAP;
    private final String value;

    private AZMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AZMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AZMode> knownValues() {
        EnumSet<AZMode> knownValues = EnumSet.allOf(AZMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AZMode.class, AZMode::toString);
    }
}

