/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsToRemoveListCopier;
import software.amazon.awssdk.services.elasticache.model.NodeGroupsToRetainListCopier;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfiguration;
import software.amazon.awssdk.services.elasticache.model.ReshardingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationGroupShardConfigurationRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, ModifyReplicationGroupShardConfigurationRequest> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationGroupId").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::replicationGroupId)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::replicationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build()}).build();
    private static final SdkField<Integer> NODE_GROUP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeGroupCount").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupCount)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::nodeGroupCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupCount").build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::applyImmediately)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<List<ReshardingConfiguration>> RESHARDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReshardingConfiguration").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::reshardingConfiguration)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::reshardingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build(), ListTrait.builder().memberLocationName("ReshardingConfiguration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReshardingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReshardingConfiguration").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NODE_GROUPS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroupsToRemove").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupsToRemove)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::nodeGroupsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupsToRemove").build(), ListTrait.builder().memberLocationName("NodeGroupToRemove").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupToRemove").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NODE_GROUPS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeGroupsToRetain").getter(ModifyReplicationGroupShardConfigurationRequest.getter(ModifyReplicationGroupShardConfigurationRequest::nodeGroupsToRetain)).setter(ModifyReplicationGroupShardConfigurationRequest.setter(Builder::nodeGroupsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupsToRetain").build(), ListTrait.builder().memberLocationName("NodeGroupToRetain").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeGroupToRetain").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD, NODE_GROUP_COUNT_FIELD, APPLY_IMMEDIATELY_FIELD, RESHARDING_CONFIGURATION_FIELD, NODE_GROUPS_TO_REMOVE_FIELD, NODE_GROUPS_TO_RETAIN_FIELD));
    private final String replicationGroupId;
    private final Integer nodeGroupCount;
    private final Boolean applyImmediately;
    private final List<ReshardingConfiguration> reshardingConfiguration;
    private final List<String> nodeGroupsToRemove;
    private final List<String> nodeGroupsToRetain;

    private ModifyReplicationGroupShardConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.replicationGroupId = builder.replicationGroupId;
        this.nodeGroupCount = builder.nodeGroupCount;
        this.applyImmediately = builder.applyImmediately;
        this.reshardingConfiguration = builder.reshardingConfiguration;
        this.nodeGroupsToRemove = builder.nodeGroupsToRemove;
        this.nodeGroupsToRetain = builder.nodeGroupsToRetain;
    }

    public final String replicationGroupId() {
        return this.replicationGroupId;
    }

    public final Integer nodeGroupCount() {
        return this.nodeGroupCount;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public final boolean hasReshardingConfiguration() {
        return this.reshardingConfiguration != null && !(this.reshardingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<ReshardingConfiguration> reshardingConfiguration() {
        return this.reshardingConfiguration;
    }

    public final boolean hasNodeGroupsToRemove() {
        return this.nodeGroupsToRemove != null && !(this.nodeGroupsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> nodeGroupsToRemove() {
        return this.nodeGroupsToRemove;
    }

    public final boolean hasNodeGroupsToRetain() {
        return this.nodeGroupsToRetain != null && !(this.nodeGroupsToRetain instanceof SdkAutoConstructList);
    }

    public final List<String> nodeGroupsToRetain() {
        return this.nodeGroupsToRetain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeGroupCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReshardingConfiguration() ? this.reshardingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeGroupsToRemove() ? this.nodeGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeGroupsToRetain() ? this.nodeGroupsToRetain() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationGroupShardConfigurationRequest)) {
            return false;
        }
        ModifyReplicationGroupShardConfigurationRequest other = (ModifyReplicationGroupShardConfigurationRequest)((Object)obj);
        return Objects.equals(this.replicationGroupId(), other.replicationGroupId()) && Objects.equals(this.nodeGroupCount(), other.nodeGroupCount()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && this.hasReshardingConfiguration() == other.hasReshardingConfiguration() && Objects.equals(this.reshardingConfiguration(), other.reshardingConfiguration()) && this.hasNodeGroupsToRemove() == other.hasNodeGroupsToRemove() && Objects.equals(this.nodeGroupsToRemove(), other.nodeGroupsToRemove()) && this.hasNodeGroupsToRetain() == other.hasNodeGroupsToRetain() && Objects.equals(this.nodeGroupsToRetain(), other.nodeGroupsToRetain());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyReplicationGroupShardConfigurationRequest").add("ReplicationGroupId", (Object)this.replicationGroupId()).add("NodeGroupCount", (Object)this.nodeGroupCount()).add("ApplyImmediately", (Object)this.applyImmediately()).add("ReshardingConfiguration", this.hasReshardingConfiguration() ? this.reshardingConfiguration() : null).add("NodeGroupsToRemove", this.hasNodeGroupsToRemove() ? this.nodeGroupsToRemove() : null).add("NodeGroupsToRetain", this.hasNodeGroupsToRetain() ? this.nodeGroupsToRetain() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationGroupId()));
            }
            case "NodeGroupCount": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupCount()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "ReshardingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reshardingConfiguration()));
            }
            case "NodeGroupsToRemove": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupsToRemove()));
            }
            case "NodeGroupsToRetain": {
                return Optional.ofNullable(clazz.cast(this.nodeGroupsToRetain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationGroupShardConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyReplicationGroupShardConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String replicationGroupId;
        private Integer nodeGroupCount;
        private Boolean applyImmediately;
        private List<ReshardingConfiguration> reshardingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private List<String> nodeGroupsToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> nodeGroupsToRetain = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationGroupShardConfigurationRequest model) {
            super(model);
            this.replicationGroupId(model.replicationGroupId);
            this.nodeGroupCount(model.nodeGroupCount);
            this.applyImmediately(model.applyImmediately);
            this.reshardingConfiguration(model.reshardingConfiguration);
            this.nodeGroupsToRemove(model.nodeGroupsToRemove);
            this.nodeGroupsToRetain(model.nodeGroupsToRetain);
        }

        public final String getReplicationGroupId() {
            return this.replicationGroupId;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        @Override
        @Transient
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final Integer getNodeGroupCount() {
            return this.nodeGroupCount;
        }

        public final void setNodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
        }

        @Override
        @Transient
        public final Builder nodeGroupCount(Integer nodeGroupCount) {
            this.nodeGroupCount = nodeGroupCount;
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        @Transient
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final List<ReshardingConfiguration.Builder> getReshardingConfiguration() {
            List<ReshardingConfiguration.Builder> result = ReshardingConfigurationListCopier.copyToBuilder(this.reshardingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReshardingConfiguration(Collection<ReshardingConfiguration.BuilderImpl> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copyFromBuilder(reshardingConfiguration);
        }

        @Override
        @Transient
        public final Builder reshardingConfiguration(Collection<ReshardingConfiguration> reshardingConfiguration) {
            this.reshardingConfiguration = ReshardingConfigurationListCopier.copy(reshardingConfiguration);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reshardingConfiguration(ReshardingConfiguration ... reshardingConfiguration) {
            this.reshardingConfiguration(Arrays.asList(reshardingConfiguration));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder> ... reshardingConfiguration) {
            this.reshardingConfiguration(Stream.of(reshardingConfiguration).map(c -> (ReshardingConfiguration)((ReshardingConfiguration.Builder)ReshardingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNodeGroupsToRemove() {
            if (this.nodeGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeGroupsToRemove;
        }

        public final void setNodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
        }

        @Override
        @Transient
        public final Builder nodeGroupsToRemove(Collection<String> nodeGroupsToRemove) {
            this.nodeGroupsToRemove = NodeGroupsToRemoveListCopier.copy(nodeGroupsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeGroupsToRemove(String ... nodeGroupsToRemove) {
            this.nodeGroupsToRemove(Arrays.asList(nodeGroupsToRemove));
            return this;
        }

        public final Collection<String> getNodeGroupsToRetain() {
            if (this.nodeGroupsToRetain instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeGroupsToRetain;
        }

        public final void setNodeGroupsToRetain(Collection<String> nodeGroupsToRetain) {
            this.nodeGroupsToRetain = NodeGroupsToRetainListCopier.copy(nodeGroupsToRetain);
        }

        @Override
        @Transient
        public final Builder nodeGroupsToRetain(Collection<String> nodeGroupsToRetain) {
            this.nodeGroupsToRetain = NodeGroupsToRetainListCopier.copy(nodeGroupsToRetain);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeGroupsToRetain(String ... nodeGroupsToRetain) {
            this.nodeGroupsToRetain(Arrays.asList(nodeGroupsToRetain));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationGroupShardConfigurationRequest build() {
            return new ModifyReplicationGroupShardConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyReplicationGroupShardConfigurationRequest> {
        public Builder replicationGroupId(String var1);

        public Builder nodeGroupCount(Integer var1);

        public Builder applyImmediately(Boolean var1);

        public Builder reshardingConfiguration(Collection<ReshardingConfiguration> var1);

        public Builder reshardingConfiguration(ReshardingConfiguration ... var1);

        public Builder reshardingConfiguration(Consumer<ReshardingConfiguration.Builder> ... var1);

        public Builder nodeGroupsToRemove(Collection<String> var1);

        public Builder nodeGroupsToRemove(String ... var1);

        public Builder nodeGroupsToRetain(Collection<String> var1);

        public Builder nodeGroupsToRetain(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

