/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheRequest;
import software.amazon.awssdk.services.elasticache.model.PasswordListInputCopier;
import software.amazon.awssdk.services.elasticache.model.Tag;
import software.amazon.awssdk.services.elasticache.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserRequest
extends ElastiCacheRequest
implements ToCopyableBuilder<Builder, CreateUserRequest> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(CreateUserRequest.getter(CreateUserRequest::userId)).setter(CreateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(CreateUserRequest.getter(CreateUserRequest::userName)).setter(CreateUserRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateUserRequest.getter(CreateUserRequest::engine)).setter(CreateUserRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Passwords").getter(CreateUserRequest.getter(CreateUserRequest::passwords)).setter(CreateUserRequest.setter(Builder::passwords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(CreateUserRequest.getter(CreateUserRequest::accessString)).setter(CreateUserRequest.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<Boolean> NO_PASSWORD_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoPasswordRequired").getter(CreateUserRequest.getter(CreateUserRequest::noPasswordRequired)).setter(CreateUserRequest.setter(Builder::noPasswordRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoPasswordRequired").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateUserRequest.getter(CreateUserRequest::tags)).setter(CreateUserRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, USER_NAME_FIELD, ENGINE_FIELD, PASSWORDS_FIELD, ACCESS_STRING_FIELD, NO_PASSWORD_REQUIRED_FIELD, TAGS_FIELD));
    private final String userId;
    private final String userName;
    private final String engine;
    private final List<String> passwords;
    private final String accessString;
    private final Boolean noPasswordRequired;
    private final List<Tag> tags;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.engine = builder.engine;
        this.passwords = builder.passwords;
        this.accessString = builder.accessString;
        this.noPasswordRequired = builder.noPasswordRequired;
        this.tags = builder.tags;
    }

    public final String userId() {
        return this.userId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String engine() {
        return this.engine;
    }

    public final boolean hasPasswords() {
        return this.passwords != null && !(this.passwords instanceof SdkAutoConstructList);
    }

    public final List<String> passwords() {
        return this.passwords;
    }

    public final String accessString() {
        return this.accessString;
    }

    public final Boolean noPasswordRequired() {
        return this.noPasswordRequired;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPasswords() ? this.passwords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.noPasswordRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.engine(), other.engine()) && this.hasPasswords() == other.hasPasswords() && Objects.equals(this.passwords(), other.passwords()) && Objects.equals(this.accessString(), other.accessString()) && Objects.equals(this.noPasswordRequired(), other.noPasswordRequired()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserRequest").add("UserId", (Object)this.userId()).add("UserName", (Object)this.userName()).add("Engine", (Object)this.engine()).add("Passwords", this.hasPasswords() ? this.passwords() : null).add("AccessString", (Object)this.accessString()).add("NoPasswordRequired", (Object)this.noPasswordRequired()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "Passwords": {
                return Optional.ofNullable(clazz.cast(this.passwords()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "NoPasswordRequired": {
                return Optional.ofNullable(clazz.cast(this.noPasswordRequired()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheRequest.BuilderImpl
    implements Builder {
        private String userId;
        private String userName;
        private String engine;
        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();
        private String accessString;
        private Boolean noPasswordRequired;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            this.userId(model.userId);
            this.userName(model.userName);
            this.engine(model.engine);
            this.passwords(model.passwords);
            this.accessString(model.accessString);
            this.noPasswordRequired(model.noPasswordRequired);
            this.tags(model.tags);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Collection<String> getPasswords() {
            if (this.passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.passwords;
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String ... passwords) {
            this.passwords(Arrays.asList(passwords));
            return this;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        public final String getAccessString() {
            return this.accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        public final Boolean getNoPasswordRequired() {
            return this.noPasswordRequired;
        }

        @Override
        public final Builder noPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
            return this;
        }

        public final void setNoPasswordRequired(Boolean noPasswordRequired) {
            this.noPasswordRequired = noPasswordRequired;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserRequest> {
        public Builder userId(String var1);

        public Builder userName(String var1);

        public Builder engine(String var1);

        public Builder passwords(Collection<String> var1);

        public Builder passwords(String ... var1);

        public Builder accessString(String var1);

        public Builder noPasswordRequired(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

