/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.EC2SecurityGroup;
import software.amazon.awssdk.services.elasticache.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CacheSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CacheSecurityGroup> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(CacheSecurityGroup.getter(CacheSecurityGroup::ownerId)).setter(CacheSecurityGroup.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheSecurityGroupName").getter(CacheSecurityGroup.getter(CacheSecurityGroup::cacheSecurityGroupName)).setter(CacheSecurityGroup.setter(Builder::cacheSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CacheSecurityGroup.getter(CacheSecurityGroup::description)).setter(CacheSecurityGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2SecurityGroups").getter(CacheSecurityGroup.getter(CacheSecurityGroup::ec2SecurityGroups)).setter(CacheSecurityGroup.setter(Builder::ec2SecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(), ListTrait.builder().memberLocationName("EC2SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2SecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(CacheSecurityGroup.getter(CacheSecurityGroup::arn)).setter(CacheSecurityGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CACHE_SECURITY_GROUP_NAME_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUPS_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String cacheSecurityGroupName;
    private final String description;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final String arn;

    private CacheSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.arn = builder.arn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String cacheSecurityGroupName() {
        return this.cacheSecurityGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SecurityGroups() {
        return this.ec2SecurityGroups != null && !(this.ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSecurityGroup)) {
            return false;
        }
        CacheSecurityGroup other = (CacheSecurityGroup)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.cacheSecurityGroupName(), other.cacheSecurityGroupName()) && Objects.equals(this.description(), other.description()) && this.hasEc2SecurityGroups() == other.hasEc2SecurityGroups() && Objects.equals(this.ec2SecurityGroups(), other.ec2SecurityGroups()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"CacheSecurityGroup").add("OwnerId", (Object)this.ownerId()).add("CacheSecurityGroupName", (Object)this.cacheSecurityGroupName()).add("Description", (Object)this.description()).add("EC2SecurityGroups", this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CacheSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EC2SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroups()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheSecurityGroup, T> g) {
        return obj -> g.apply((CacheSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String cacheSecurityGroupName;
        private String description;
        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheSecurityGroup model) {
            this.ownerId(model.ownerId);
            this.cacheSecurityGroupName(model.cacheSecurityGroupName);
            this.description(model.description);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
            this.arn(model.arn);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCacheSecurityGroupName() {
            return this.cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            List<EC2SecurityGroup.Builder> result = EC2SecurityGroupListCopier.copyToBuilder(this.ec2SecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> (EC2SecurityGroup)((EC2SecurityGroup.Builder)EC2SecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public CacheSecurityGroup build() {
            return new CacheSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CacheSecurityGroup> {
        public Builder ownerId(String var1);

        public Builder cacheSecurityGroupName(String var1);

        public Builder description(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... var1);

        public Builder arn(String var1);
    }
}

