/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.services.elasticache.model.NodeTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAllowedNodeTypeModificationsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, ListAllowedNodeTypeModificationsResponse> {
    private static final SdkField<List<String>> SCALE_UP_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScaleUpModifications").getter(ListAllowedNodeTypeModificationsResponse.getter(ListAllowedNodeTypeModificationsResponse::scaleUpModifications)).setter(ListAllowedNodeTypeModificationsResponse.setter(Builder::scaleUpModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleUpModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SCALE_DOWN_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScaleDownModifications").getter(ListAllowedNodeTypeModificationsResponse.getter(ListAllowedNodeTypeModificationsResponse::scaleDownModifications)).setter(ListAllowedNodeTypeModificationsResponse.setter(Builder::scaleDownModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_UP_MODIFICATIONS_FIELD, SCALE_DOWN_MODIFICATIONS_FIELD));
    private final List<String> scaleUpModifications;
    private final List<String> scaleDownModifications;

    private ListAllowedNodeTypeModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.scaleUpModifications = builder.scaleUpModifications;
        this.scaleDownModifications = builder.scaleDownModifications;
    }

    public final boolean hasScaleUpModifications() {
        return this.scaleUpModifications != null && !(this.scaleUpModifications instanceof SdkAutoConstructList);
    }

    public final List<String> scaleUpModifications() {
        return this.scaleUpModifications;
    }

    public final boolean hasScaleDownModifications() {
        return this.scaleDownModifications != null && !(this.scaleDownModifications instanceof SdkAutoConstructList);
    }

    public final List<String> scaleDownModifications() {
        return this.scaleDownModifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScaleUpModifications() ? this.scaleUpModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScaleDownModifications() ? this.scaleDownModifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedNodeTypeModificationsResponse)) {
            return false;
        }
        ListAllowedNodeTypeModificationsResponse other = (ListAllowedNodeTypeModificationsResponse)((Object)obj);
        return this.hasScaleUpModifications() == other.hasScaleUpModifications() && Objects.equals(this.scaleUpModifications(), other.scaleUpModifications()) && this.hasScaleDownModifications() == other.hasScaleDownModifications() && Objects.equals(this.scaleDownModifications(), other.scaleDownModifications());
    }

    public final String toString() {
        return ToString.builder((String)"ListAllowedNodeTypeModificationsResponse").add("ScaleUpModifications", this.hasScaleUpModifications() ? this.scaleUpModifications() : null).add("ScaleDownModifications", this.hasScaleDownModifications() ? this.scaleDownModifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScaleUpModifications": {
                return Optional.ofNullable(clazz.cast(this.scaleUpModifications()));
            }
            case "ScaleDownModifications": {
                return Optional.ofNullable(clazz.cast(this.scaleDownModifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedNodeTypeModificationsResponse, T> g) {
        return obj -> g.apply((ListAllowedNodeTypeModificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private List<String> scaleUpModifications = DefaultSdkAutoConstructList.getInstance();
        private List<String> scaleDownModifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedNodeTypeModificationsResponse model) {
            super(model);
            this.scaleUpModifications(model.scaleUpModifications);
            this.scaleDownModifications(model.scaleDownModifications);
        }

        public final Collection<String> getScaleUpModifications() {
            if (this.scaleUpModifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scaleUpModifications;
        }

        @Override
        public final Builder scaleUpModifications(Collection<String> scaleUpModifications) {
            this.scaleUpModifications = NodeTypeListCopier.copy(scaleUpModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleUpModifications(String ... scaleUpModifications) {
            this.scaleUpModifications(Arrays.asList(scaleUpModifications));
            return this;
        }

        public final void setScaleUpModifications(Collection<String> scaleUpModifications) {
            this.scaleUpModifications = NodeTypeListCopier.copy(scaleUpModifications);
        }

        public final Collection<String> getScaleDownModifications() {
            if (this.scaleDownModifications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scaleDownModifications;
        }

        @Override
        public final Builder scaleDownModifications(Collection<String> scaleDownModifications) {
            this.scaleDownModifications = NodeTypeListCopier.copy(scaleDownModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleDownModifications(String ... scaleDownModifications) {
            this.scaleDownModifications(Arrays.asList(scaleDownModifications));
            return this;
        }

        public final void setScaleDownModifications(Collection<String> scaleDownModifications) {
            this.scaleDownModifications = NodeTypeListCopier.copy(scaleDownModifications);
        }

        @Override
        public ListAllowedNodeTypeModificationsResponse build() {
            return new ListAllowedNodeTypeModificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAllowedNodeTypeModificationsResponse> {
        public Builder scaleUpModifications(Collection<String> var1);

        public Builder scaleUpModifications(String ... var1);

        public Builder scaleDownModifications(Collection<String> var1);

        public Builder scaleDownModifications(String ... var1);
    }
}

