/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroup;
import software.amazon.awssdk.services.elasticache.model.CacheSecurityGroupsCopier;
import software.amazon.awssdk.services.elasticache.model.ElastiCacheResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCacheSecurityGroupsResponse
extends ElastiCacheResponse
implements ToCopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCacheSecurityGroupsResponse.getter(DescribeCacheSecurityGroupsResponse::marker)).setter(DescribeCacheSecurityGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<CacheSecurityGroup>> CACHE_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CacheSecurityGroups").getter(DescribeCacheSecurityGroupsResponse.getter(DescribeCacheSecurityGroupsResponse::cacheSecurityGroups)).setter(DescribeCacheSecurityGroupsResponse.setter(Builder::cacheSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroups").build(), ListTrait.builder().memberLocationName("CacheSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CacheSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CACHE_SECURITY_GROUPS_FIELD));
    private final String marker;
    private final List<CacheSecurityGroup> cacheSecurityGroups;

    private DescribeCacheSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.cacheSecurityGroups = builder.cacheSecurityGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasCacheSecurityGroups() {
        return this.cacheSecurityGroups != null && !(this.cacheSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<CacheSecurityGroup> cacheSecurityGroups() {
        return this.cacheSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCacheSecurityGroups() ? this.cacheSecurityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCacheSecurityGroupsResponse)) {
            return false;
        }
        DescribeCacheSecurityGroupsResponse other = (DescribeCacheSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasCacheSecurityGroups() == other.hasCacheSecurityGroups() && Objects.equals(this.cacheSecurityGroups(), other.cacheSecurityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCacheSecurityGroupsResponse").add("Marker", (Object)this.marker()).add("CacheSecurityGroups", this.hasCacheSecurityGroups() ? this.cacheSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "CacheSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.cacheSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCacheSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeCacheSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElastiCacheResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<CacheSecurityGroup> cacheSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCacheSecurityGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.cacheSecurityGroups(model.cacheSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<CacheSecurityGroup.Builder> getCacheSecurityGroups() {
            List<CacheSecurityGroup.Builder> result = CacheSecurityGroupsCopier.copyToBuilder(this.cacheSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cacheSecurityGroups(Collection<CacheSecurityGroup> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copy(cacheSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(CacheSecurityGroup ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Arrays.asList(cacheSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheSecurityGroups(Consumer<CacheSecurityGroup.Builder> ... cacheSecurityGroups) {
            this.cacheSecurityGroups(Stream.of(cacheSecurityGroups).map(c -> (CacheSecurityGroup)((CacheSecurityGroup.Builder)CacheSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCacheSecurityGroups(Collection<CacheSecurityGroup.BuilderImpl> cacheSecurityGroups) {
            this.cacheSecurityGroups = CacheSecurityGroupsCopier.copyFromBuilder(cacheSecurityGroups);
        }

        @Override
        public DescribeCacheSecurityGroupsResponse build() {
            return new DescribeCacheSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElastiCacheResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCacheSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder cacheSecurityGroups(Collection<CacheSecurityGroup> var1);

        public Builder cacheSecurityGroups(CacheSecurityGroup ... var1);

        public Builder cacheSecurityGroups(Consumer<CacheSecurityGroup.Builder> ... var1);
    }
}

