/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.elasticache.model.ServiceUpdate;

public class DescribeServiceUpdatesIterable
implements SdkIterable<DescribeServiceUpdatesResponse> {
    private final ElastiCacheClient client;
    private final DescribeServiceUpdatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServiceUpdatesIterable(ElastiCacheClient client, DescribeServiceUpdatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeServiceUpdatesResponseFetcher();
    }

    public Iterator<DescribeServiceUpdatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceUpdate> serviceUpdates() {
        Function<DescribeServiceUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceUpdates() != null) {
                return response.serviceUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServiceUpdatesResponseFetcher
    implements SyncPageFetcher<DescribeServiceUpdatesResponse> {
        private DescribeServiceUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeServiceUpdatesResponse nextPage(DescribeServiceUpdatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceUpdatesIterable.this.client.describeServiceUpdates(DescribeServiceUpdatesIterable.this.firstRequest);
            }
            return DescribeServiceUpdatesIterable.this.client.describeServiceUpdates((DescribeServiceUpdatesRequest)((Object)DescribeServiceUpdatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

