/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public class DescribeEngineDefaultParametersIterable
implements SdkIterable<DescribeEngineDefaultParametersResponse> {
    private final ElastiCacheClient client;
    private final DescribeEngineDefaultParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEngineDefaultParametersIterable(ElastiCacheClient client, DescribeEngineDefaultParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEngineDefaultParametersResponseFetcher();
    }

    public Iterator<DescribeEngineDefaultParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeEngineDefaultParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineDefaults() != null && response.engineDefaults().parameters() != null) {
                return response.engineDefaults().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEngineDefaultParametersResponseFetcher
    implements SyncPageFetcher<DescribeEngineDefaultParametersResponse> {
        private DescribeEngineDefaultParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineDefaultParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.engineDefaults().marker());
        }

        public DescribeEngineDefaultParametersResponse nextPage(DescribeEngineDefaultParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineDefaultParametersIterable.this.client.describeEngineDefaultParameters(DescribeEngineDefaultParametersIterable.this.firstRequest);
            }
            return DescribeEngineDefaultParametersIterable.this.client.describeEngineDefaultParameters((DescribeEngineDefaultParametersRequest)((Object)DescribeEngineDefaultParametersIterable.this.firstRequest.toBuilder().marker(previousPage.engineDefaults().marker()).build()));
        }
    }
}

